package com.artfess.cgpt.order.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.order.model.BizUserApplicationMatDetails;
import com.artfess.cgpt.order.model.BizUserApplicationProjectDetails;
import com.artfess.cgpt.order.dao.BizUserApplicationProjectDetailsDao;
import com.artfess.cgpt.order.manager.BizUserApplicationProjectDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户报名订单项目明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizUserApplicationProjectDetailsManagerImpl extends BaseManagerImpl<BizUserApplicationProjectDetailsDao, BizUserApplicationProjectDetails> implements BizUserApplicationProjectDetailsManager {
    @Autowired
    private UCFeignService ucFeignService;
    @Override
    public PageList<BizUserApplicationProjectDetails> queryAllByPage(QueryFilter<BizUserApplicationProjectDetails> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizUserApplicationProjectDetails> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }
}
