package com.artfess.cgpt.myTask;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2023/1/11 17:42
 */

@RestController
@RequestMapping("/myTask")
@Api(tags = "流程管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MyTaskController {

    @Resource
    IFlowManager iFlowService;
    @Resource
    BaseContext baseContext;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Autowired
    private BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    /**
     * 流程-我的申请
     *
     * @param queryFilter 通用查询器
     * @return 查询数据
     */
    @PostMapping("/myRequest")
    @ApiOperation(value = "M-流程-我的请求", notes = "参数说明：通用查询器", httpMethod = "POST")
    public PageList<DefaultBpmProcessInstance> myRequest(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter queryFilter) throws Exception {
        String noticeTitle = null;
        List querys = queryFilter.getQuerys();
        PageBean pageBean = queryFilter.getPageBean();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(Object qf : querys){
                QueryField q = (QueryField) qf;
                if(q.getProperty().equals("bizNoticeName")){
                    noticeTitle = String.valueOf(q.getValue());
                    q.setProperty("1");
                    q.setValue("1");
                    q.setOperation(QueryOP.EQUAL);
                    q.setGroup("a");
                    break;
                }
            }
        }

        List<String> ids = new ArrayList<>();

        queryFilter.setPageBean(new PageBean(0,-1,false));
        List<DefaultBpmProcessInstance> data = iFlowService.myRequest(baseContext.getCurrentUserAccout(), queryFilter).getRows();
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(DefaultBpmProcessInstance temp : data){
                String bizKey = temp.getBizKey();
                if(BeanUtils.isNotEmpty(bizKey)){
                    MatApproval matApproval = matApprovalManager.getById(bizKey);
                    if(BeanUtils.isNotEmpty(matApproval)){
                        temp.setBizNoticeName(matApproval.getNoticeTitle());
                        if(BeanUtils.isNotEmpty(noticeTitle) && temp.getBizNoticeName().contains(noticeTitle)){
                            ids.add(temp.getId());
                        }
                    }
                }
            }
        }

        if(ids.size()>0){
            queryFilter.addFilter("bpm_pro_inst.id_",ids, QueryOP.IN);
        }

        queryFilter.setPageBean(pageBean);
        PageList<DefaultBpmProcessInstance> result = iFlowService.myRequest(baseContext.getCurrentUserAccout(), queryFilter);
        List<DefaultBpmProcessInstance> rows = result.getRows();
        if(BeanUtils.isNotEmpty(rows) && rows.size()>0){
            for(DefaultBpmProcessInstance dbpi : rows){
                List<String> collect = data.stream().filter(s -> s.getId().equals(dbpi.getId()) && BeanUtils.isNotEmpty(s.getBizNoticeName())).map(x -> x.getBizNoticeName()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(collect) && collect.size()>0) {
                    dbpi.setBizNoticeName(collect.get(0));
                }
            }
        }
        return result;
    }

    /**
     * 流程-已办事项
     * @param queryFilter
     * @param status
     * @param response
     * @return
     * @throws Exception
     */
    @PostMapping("/itemsToBeDone")
    @ApiOperation(value = "M-流程-已办事项", httpMethod = "POST", notes = "获取用户的已办事宜，参数status表示流程状态，不填表示查询所有")
    public PageList<Map<String, Object>> getDoneInstList(
            @ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter queryFilter,
            @ApiParam(name = "status", value = "流程状态", allowableValues = "running,end,manualend,cancel,back,revoke,revokeToStart", required = false) @RequestParam(required = false) String status,
            HttpServletResponse response) throws Exception {
        String noticeTitle = null;
        List querys = queryFilter.getQuerys();
        PageBean pageBean = queryFilter.getPageBean();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(Object qf : querys){
                QueryField q = (QueryField) qf;
                if(q.getProperty().equals("bizNoticeName")){
                    noticeTitle = String.valueOf(q.getValue());
                    q.setProperty("1");
                    q.setValue("1");
                    q.setOperation(QueryOP.EQUAL);
                    q.setGroup("a");
                    break;
                }
            }
        }
        List<String> ids = new ArrayList<>();
        queryFilter.setPageBean(new PageBean(0,-1,false));
        List<Map<String, Object>> data = iFlowService.getDoneInstList(baseContext.getCurrentUserAccout(), queryFilter, status).get().getRows();
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(Map temp : data){
                Object bizKey = temp.get("bizKey");
                if(BeanUtils.isNotEmpty(bizKey)){
                    MatApproval matApproval = matApprovalManager.getById(bizKey.toString());
                    if(BeanUtils.isNotEmpty(matApproval)){
                        temp.put("bizNoticeName",matApproval.getNoticeTitle());
                        if(BeanUtils.isNotEmpty(noticeTitle) && matApproval.getNoticeTitle().contains(noticeTitle)){
                            ids.add(temp.get("id").toString());
                        }
                    }
                }
            }
        }

        if(ids.size()>0){
            queryFilter.addFilter("wfInst.id_",ids, QueryOP.IN);
        }

        queryFilter.setPageBean(pageBean);

        PageList<Map<String, Object>> result = iFlowService.getDoneInstList(baseContext.getCurrentUserAccout(), queryFilter, status).get();
        List<Map<String, Object>> rows = result.getRows();
        if(BeanUtils.isNotEmpty(rows) && rows.size()>0){
            for(Map temp : rows){
                List<String> collect = data.stream().filter(s -> s.get("id").equals(temp.get("id")) && BeanUtils.isNotEmpty(s.get("bizNoticeName"))).map(x -> x.get("bizNoticeName").toString()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(collect) && collect.size()>0) {
                    temp.put("bizNoticeName",collect.get(0));
                }
            }
        }
        return result;
    }

    /**
     * 流程-待办事项
     * @param queryFilter
     * @return
     * @throws Exception
     */
    @PostMapping("/toDoItems")
    @ApiOperation(value = "M-流程-待办事项", httpMethod = "POST", notes = "获取用户的待办事宜")
    public PageList<DefaultBpmTask> getTodoList(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        if (BeanUtils.isNotEmpty(queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            List<QueryField> fields = new ArrayList<>();
            for (Iterator<QueryField> iterator = queryFilter.getQuerys().iterator(); iterator.hasNext(); ) {
                QueryField field = (QueryField) iterator.next();
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter<DefaultBpmDefinition> defFilter = QueryFilter.<DefaultBpmDefinition>build();
                    defFilter.addFilter("IS_MAIN_", "Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", "1", QueryOP.EQUAL);
                    PageList<DefaultBpmDefinition> query = bpmDefinitionManager.query(defFilter);
                    List<String> defKeys = new ArrayList<>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty(query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                } else {
                    fields.add(field);
                }
            }
            queryFilter.setQuerys(fields);
        }

        String noticeTitle = null;
        List querys = queryFilter.getQuerys();
        PageBean pageBean = queryFilter.getPageBean();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(Object qf : querys){
                QueryField q = (QueryField) qf;
                if(q.getProperty().equals("bizNoticeName")){
                    noticeTitle = String.valueOf(q.getValue());
                    q.setProperty("1");
                    q.setValue("1");
                    q.setOperation(QueryOP.EQUAL);
                    q.setGroup("a");
                    break;
                }
            }
        }
        List<String> ids = new ArrayList<>();
        queryFilter.setPageBean(new PageBean(0,-1,false));
        List<DefaultBpmTask> data = iFlowService.getTodoList(baseContext.getCurrentUserAccout(), queryFilter).get().getRows();
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(DefaultBpmTask temp : data){
                DefaultBpmProcessInstance bpi = bpmProcessInstanceManager.getById(temp.getProcInstId());
                if(BeanUtils.isNotEmpty(bpi) && BeanUtils.isNotEmpty(bpi.getBizKey())){
                    String bizKey = bpi.getBizKey();
                    MatApproval matApproval = matApprovalManager.getById(bizKey);
                    if(BeanUtils.isNotEmpty(matApproval)){
                        temp.setBizNoticeName(matApproval.getNoticeTitle());
                        if(BeanUtils.isNotEmpty(noticeTitle) && temp.getBizNoticeName().contains(noticeTitle)){
                            ids.add(temp.getId());
                        }
                    }
                }
            }
        }

        if(ids.size()>0){
            queryFilter.addFilter("id_",ids, QueryOP.IN);
        }
        queryFilter.setPageBean(pageBean);

        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList<DefaultBpmTask> result = iFlowService.getTodoList(baseContext.getCurrentUserAccout(), queryFilter).get();
        List<DefaultBpmTask> rows = result.getRows();
        if(BeanUtils.isNotEmpty(rows) && rows.size()>0){
            for(DefaultBpmTask dbt : rows){
                List<String> collect = data.stream().filter(s -> s.getId().equals(dbt.getId()) && BeanUtils.isNotEmpty(s.getBizNoticeName())).map(x -> x.getBizNoticeName()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(collect) && collect.size()>0) {
                    dbt.setBizNoticeName(collect.get(0));
                }
            }
        }

        return result;
    }


    /**
     * 流程-删除草稿
     * @param ids
     * @return
     * @throws Exception
     */
    @PostMapping("/removeMyquest")
    @ApiOperation(value = "M-流程-删除草稿", httpMethod = "POST", notes = "删除草稿")
    @Transactional
    public CommonResult<String> removeDraftById(
            @ApiParam(name = "ids", value = "流程实例id，多个用“,”号隔开", required = true) @RequestParam String ids)
            throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty(ids)) {
            aryIds = ids.split(",");
        }
        for (String str : aryIds) {
            DefaultBpmProcessInstance bpi = bpmProcessInstanceManager.get(str);
            if(bpi.getProcDefKey().equals("lxfb")){

            }
            bpmProcessInstanceManager.removeBpm(str);
        }
        return new CommonResult<>(true, "删除草稿成功", "");
    }

    /**
     * 查询流程任务列表
     * @param queryFilter
     * @return
     * @throws Exception
     */
    @PostMapping("/getTaskList")
    @ApiOperation(value = "M-查询流程任务列表", httpMethod = "POST", notes = "查询流程任务列表")
    public PageList<DefaultBpmTask> getTaskList(@ApiParam(required = true, name = "queryFilter", value = "查询参数对象") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        PageList<DefaultBpmTask> query = bpmTaskManager.query(queryFilter);
        if (BeanUtils.isEmpty(query) || BeanUtils.isEmpty(query.getRows())) {
            return query;
        }

        Map<String, List<DefaultBpmTaskCandidate>> cMap = new HashMap<>();
        for (DefaultBpmTask task : query.getRows()) {
            if (StringUtil.isEmpty(task.getAssigneeName())) {
                cMap.put(task.getTaskId(), new ArrayList<>());
            }
        }

        Set<String> keySet = cMap.keySet();
        if (BeanUtils.isNotEmpty(keySet)) {
            QueryFilter<DefaultBpmTaskCandidate> cQueryFilter = QueryFilter.build();
            cQueryFilter.addFilter("task_id_", StringUtil.join(keySet, ","), QueryOP.IN);
            BpmTaskCandidateManager candidateManager = AppUtil.getBean(BpmTaskCandidateManager.class);
            PageList<DefaultBpmTaskCandidate> candidateQuery = candidateManager.query(cQueryFilter);
            if (BeanUtils.isEmpty(candidateQuery) || BeanUtils.isEmpty(candidateQuery.getRows())) {
                return query;
            }
            for (DefaultBpmTaskCandidate candidate : candidateQuery.getRows()) {
                cMap.get(candidate.getTaskId()).add(candidate);
            }
            for (DefaultBpmTask task : query.getRows()) {
                if (cMap.containsKey(task.getTaskId()) && BeanUtils.isNotEmpty(cMap.get(task.getTaskId()))) {
                    List<DefaultBpmTaskCandidate> list = cMap.get(task.getTaskId());
                    List<BpmIdentity> identityList = new ArrayList<>();
                    for (DefaultBpmTaskCandidate candidate : list) {
                        identityList.add(new DefaultBpmIdentity(candidate.getExecutor(), "", candidate.getType()));
                    }
                    task.setIdentityList(identityList);
                }
            }
        }

        return query;
    }

}
