package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.time.LocalDateTime;

/**
 * @Description:平台物料库
 * @Author: Rong Tao
 * @Date: 2024/7/25 18:29
 */
@ApiModel(value="PlatMaterial对象", description="平台物料库")
@Data
@TableName("biz_plat_material")
public class PlatMaterial extends BizModel<PlatMaterial> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_")
    @Excel(name = "物料分类")
    private String matCategory;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    @Excel(name = "平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    @Excel(name = "物料名称")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    @Excel(name = "物料牌号")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    @Excel(name = "规格型号")
    private String matSpec;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    @Excel(name = "计量单位")
    private String matUnit;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    @Excel(name = "品牌")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    @Excel(name = "基础扩展")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    @Excel(name = "其他扩展")
    private String matOtherExt;

    @ApiModelProperty(value = "税率")
    @TableField("MAT_TAXRATE_")
    @Excel(name = "税率(%)")
    private Integer matTaxrate;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    @Excel(name = "是否集采(0:自采,1:集采)")
    private Integer matIfPlat;

    @ApiModelProperty(value = "启用状态（0：禁用，1：启用）")
    @TableField("MAT_STATUS_")
    @Excel(name = "状态(0:禁用,1:启用)")
    private Integer matStatus;

    @ApiModelProperty(value = "同步时间")
    @TableField("MAT_TRANSFER_TIME_")
    private LocalDateTime matTransferTime;

}
