package com.artfess.cgpt.material.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagement;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.material.vo.MaterialHierarchicalManagementQueryVo;

import java.util.List;

/**
 * 物料分级管理表 服务类
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
public interface MaterialHierarchicalManagementManager extends BaseManager<MaterialHierarchicalManagement> {

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<MaterialHierarchicalManagementQueryVo> queryAllByPage(QueryFilter<MaterialHierarchicalManagement> queryFilter);

    /**
     * 不分页查询下级物料数据
     * @param parentId
     * @return
     */
    List<MaterialHierarchicalManagementQueryVo> queryAllByParentId(String parentId);

    /**
     * 根据物料ID查询记录数，用于判断是否已经添加过
     * @param t
     * @return
     */
    int countByMatId(MaterialHierarchicalManagement t);

    /**
     * 根据id递归查询所有父级ID集（包括自己），可以用于排除物料信息
     * @param id
     * @return
     */
    List<MaterialHierarchicalManagement> getParentById(String id);
}
