package com.artfess.cgpt.expert.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:专家评标类型表
 * @Author: Rong Tao
 * @Date: 2024/7/3 16:28
 */
@ApiModel(value="BizExpertDatabaseEvaType对象", description="专家评标类型表")
@Data
@TableName("biz_expert_database_eva_type")
public class BizExpertDatabaseEvaType extends BizNoModel<BizExpertDatabaseEvaType> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专家库ID（关联专家库表ID）")
    @TableField("EXPERT_DATABASE_ID_")
    private String expertDatabaseId;

    @ApiModelProperty(value = "评标类型（1.物资类，2.设备类）")
    @TableField("EXPERT_EVA_TYPE_")
    private Integer expertEvaType;

}
