package com.artfess.cgpt.expert.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseExpertTypeManager;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.expert.model.BizExpertDatabaseEvaType;
import com.artfess.cgpt.expert.model.BizExpertDatabaseExpertType;
import com.artfess.cgpt.expert.model.BizExpertType;
import com.artfess.cgpt.expert.dao.BizExpertTypeDao;
import com.artfess.cgpt.expert.manager.BizExpertTypeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.qualification.model.BizQualificationCategory;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.model.AdmissionConfigQualification;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 专家分类表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizExpertTypeManagerImpl extends BaseManagerImpl<BizExpertTypeDao, BizExpertType> implements BizExpertTypeManager {

    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizExpertDatabaseExpertTypeManager expertDatabaseExpertTypeManager;

    @Override
    public PageList<BizExpertType> queryAllByPage(QueryFilter<BizExpertType> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

//        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizExpertType> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public void saveOrUpdateEntity(BizExpertType entity) {
        if(BeanUtils.isEmpty(entity.getExpertTypeCode())){
            entity.setExpertTypeCode(BizUtils.getNextSerialNumber(systemConfigFeignService,"zjfl_flbh"));
        }

        if(BeanUtils.isNotEmpty(entity.getId())){
            //更新，判断是否有专家引用了该分类，如果引用了就不能修改
            existData(entity);
        }

        super.saveOrUpdate(entity);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        List<BizExpertType> dataList = super.listByIds(ids);
        for(BizExpertType data : dataList){
            //判断是否存在关联数据，如果存在，不能删除
            existData(data);
        }
        super.removeByIds(ids);
    }

    /**
     * 校验是否已存在关联数据
     * @param data
     */
    void existData(BizExpertType data){
        //查询专家分类_专家关联表
        LambdaQueryWrapper<BizExpertDatabaseExpertType> qw1 = new LambdaQueryWrapper<>();
        qw1.eq(BizExpertDatabaseExpertType::getExpertTypeId,data.getId());
        if(expertDatabaseExpertTypeManager.count(qw1)>0){
            throw new BaseException("专家分类【"+data.getExpertTypeCode()+"】已存在关联数据，无法操作");
        }

    }

}
