package com.artfess.cgpt.evaluation.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 评标体系使用单位表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizEvaluationSystemUseOrg对象", description="评标体系使用单位表")
@TableName("biz_evaluation_system_use_org")
@Data
public class BizEvaluationSystemUseOrg extends BaseModel<BizEvaluationSystemUseOrg> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评标体系表ID（关联评标体系表ID）")
    @TableField("EVALUATION_SYSTEM_ID_")
    private String evaluationSystemId;

    @ApiModelProperty(value = "组织ID（关联ORG组织表ID）")
    @TableField("ORG_ID_")
    private String orgId;

}
