package com.artfess.cgpt.evaluation.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 评标体系表，综合评标法/最低价评标法都用此表，综合评标法有明细，最低价评标法无明细
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizEvaluationSystem对象", description="评标体系表，综合评标法/最低价评标法都用此表，综合评标法有明细，最低价评标法无明细")
@TableName("biz_evaluation_system")
@Data
public class BizEvaluationSystem extends BizNoModel<BizEvaluationSystem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "评标类别（1：物资类，2：设备类，3.服务类，4.工程类）")
    @TableField("EVA_TYPE_")
    private Integer evaType;

    @ApiModelProperty(value = "编制单位ID（关联ORG表ID）")
    @TableField("PREPARED_ORG_ID_")
    private String preparedOrgId;

    @ApiModelProperty(value = "编制时间")
    @TableField("PREPARED_TIME_")
    private LocalDateTime preparedTime;

    @ApiModelProperty(value = "评标说明")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "评标明细集合")
    @TableField(exist = false)
    private List<BizEvaluationSystemDescription> descriptionList;

    @ApiModelProperty(value = "使用单位集合")
    @TableField(exist = false)
    private List<BizEvaluationSystemUseOrg> useOrgList;

    @ApiModelProperty(value = "使用单位名称集合")
    @TableField(exist = false)
    private List<Org> orgs;

    @ApiModelProperty(value = "使用单位ID")
    @TableField(exist = false)
    private String useOrgId;

}
