package com.artfess.cgpt.bidding.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * 评标记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizBidEvaluationManager extends BaseManager<BizBidEvaluation> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizBidEvaluation> queryAllByPage(QueryFilter<BizBidEvaluation> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(BizBidEvaluation entity);

    /**
     * 评分（综合评标法）
     * @param data
     */
    void saveByEva(List<BizBidEvaluation> data);


    /**
     * 评标-综合评标法（以供应商评标）
     * @param entity
     */
    void saveByEva(BizBidEvaluation entity);

    /**
     * 评标-综合评标法（以物料评标）
     * @param entity
     */
    void saveByEvaMat(BizBidEvaluation entity);

    /**
     * 评标（最低评标法）
     * @param biddingQuotation
     */
    void bidEvaLowest(BizBiddingQuotation biddingQuotation);

    /**
     * 物资评标-最低价评标法（以物料评标）
     * @param evaVo
     */
    void bidEvaLowest(EvaVo evaVo);

    /**
     * 项目评标-最低价评标法（以物料评标）
     * @param evaVo
     */
    void choiceBidEvaLowestPro(EvaVo evaVo);

    /**
     * 评标-最低价评标法（以物料评标），开标自动评标
     * @param evaVo
     */
    void bidEvaLowestAuto(EvaVo evaVo);

    /**
     * 根据报价公司和立项查询总得分
     * @param quoOrgId 报价公司ID
     * @param noticeId 立项ID
     * @return
     */
    BigDecimal getTotalScore(String quoOrgId,String noticeId);

    /**
     * 物资定标管理-查看明细（综合-以物料评标）
     * @param queryFilter
     * @return
     */
    PageList<BizBidEvaluation> getCalibraDetailComprehensive(QueryFilter<BizBidEvaluation> queryFilter);

    /**
     * 项目定标管理-查看明细（综合-以物料评标）
     * @param queryFilter
     * @return
     */
    PageList<BizBidEvaluation> getCalibraDetailComprehensivePro(QueryFilter<BizBidEvaluation> queryFilter);

    /**
     * 物资定标管理-查看明细（最低价评标法）
     * @param queryFilter
     * @return
     */
    PageList<BizBidEvaluation> getCalibraDetailById(QueryFilter<BizBidEvaluation> queryFilter);

    /**
     * 评标查看-导出明细（最低价评标法）
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportCalibraDetail(QueryFilter<BizBidEvaluation> queryFilter, HttpServletResponse response) throws IOException;


    /**
     * 项目定标管理-查看明细（最低价评标法）
     * @param queryFilter
     * @return
     */
    PageList<BizBidEvaluation> getCalibraDetailByIdPro(QueryFilter<BizBidEvaluation> queryFilter);

    /**
     * 定标管理-查看物资明细（综合-以供应商评标）
     * @param noticeId
     * @return
     */
    List<BizBidEvaluation> getCalibraDetailMaxScoreById(String noticeId);

    /**
     * 定标管理-查看项目明细（综合-以供应商评标）
     * @param noticeId
     * @return
     */
    List<BizBidEvaluation> getCalibraDetailMaxScoreByIdPro(String noticeId);

}
