package com.artfess.cgpt.bidding.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/4 19:59
 */
public interface BidEvaluationRecordManager extends BaseManager<BidEvaluationRecord> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BidEvaluationRecord> queryAllByPage(QueryFilter<BidEvaluationRecord> queryFilter);

    /**
     * 分页查询数据（包含明细）
     * @param queryFilter
     * @return
     */
    PageList<BidEvaluationRecord> pageAndDetail(QueryFilter<BidEvaluationRecord> queryFilter);

    /**
     * 评标-综合评标法（以供应商评标）
     * @param entity
     */
    void saveByEva(BidEvaluationRecord entity);

    /**
     * 提交评标-综合评标法（以供应商评标）
     * @param entity
     */
    void submitBidEvaluationOrg(BidEvaluationRecord entity);

    /**
     * 评标-综合评标法（以物料评标）
     * @param entity
     */
    void saveByEvaMat(BidEvaluationRecord entity);

    /**
     * 提交评标-综合评标法（以物料评标）
     * @param entity
     */
    void submitBidEvaluation(BidEvaluationRecord entity);

}
