package com.artfess.cgpt.bidding.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.bidding.model.BizBidOpening;
import com.artfess.cgpt.bidding.manager.BizBidOpeningManager;

/**
 * 开标记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@RestController
@RequestMapping("/bizBidOpening/v1/")
@Api(tags="开标记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizBidOpeningController extends BaseController<BizBidOpeningManager, BizBidOpening> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizBidOpening>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizBidOpening> queryFilter) {
        PageList<BizBidOpening> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
