/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.dao.PlatMaterialDao;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatMaterialManagerImpl
extends BaseManagerImpl<PlatMaterialDao, PlatMaterial>
implements PlatMaterialManager {
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private BizMaterialManager materialManager;

    @Override
    public PageList<PlatMaterial> queryAllByPage(QueryFilter<PlatMaterial> queryFilter) {
        IPage<PlatMaterial> result = ((PlatMaterialDao)this.baseMapper).queryAllByPage((IPage<PlatMaterial>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PlatMaterial>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void updateMatStatus(List<String> ids, String status) {
        List platMaterials = super.listByIds(ids);
        List platCodes = platMaterials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());
        if (status.equals("0")) {
            QueryWrapper applicationDetailQW = new QueryWrapper();
            applicationDetailQW.select(new String[]{"DISTINCT MAT_PLATCODE_"}).lambda().in(PurchasingApplicationDetails::getMatPlatcode, platCodes);
            List objList = this.applicationDetailsManager.listObjs((Wrapper)applicationDetailQW);
            if (BeanUtils.isNotEmpty((Object)objList) && objList.size() > 0) {
                List matPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("\u5e73\u53f0\u7269\u6599\u7f16\u53f7\u3010" + String.join((CharSequence)",", matPlatCodes) + "\u3011\u5df2\u6709\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u7981\u7528");
            }
        }
        LambdaUpdateWrapper platMaterialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)platMaterialUW.set(PlatMaterial::getMatStatus, (Object)status)).in(PlatMaterial::getId, ids)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)platMaterialUW);
        LambdaUpdateWrapper materialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)materialUW.set(BizMaterial::getMatStatus, (Object)status)).in(BizMaterial::getMatPlatcode, platCodes)).eq(BizModel::getIsDele, (Object)"0");
        this.materialManager.update((Wrapper)materialUW);
    }

    @Override
    @Transactional
    public void updateMatCategory(List<String> ids, String categoryCode) {
        List platMaterials = super.listByIds(ids);
        List platCodes = platMaterials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());
        LambdaUpdateWrapper platMaterialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)platMaterialUW.set(PlatMaterial::getMatCategory, (Object)categoryCode)).in(PlatMaterial::getId, ids)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)platMaterialUW);
        LambdaUpdateWrapper materialUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)materialUW.set(BizMaterial::getMatCategory, (Object)categoryCode)).in(BizMaterial::getMatPlatcode, platCodes)).eq(BizModel::getIsDele, (Object)"0");
        this.materialManager.update((Wrapper)materialUW);
    }

    @Override
    public void exportExcelData(QueryFilter<PlatMaterial> queryFilter, HttpServletResponse response) throws IOException {
        PageList<PlatMaterial> bizMaterialPageList = this.queryAllByPage(queryFilter);
        List data = bizMaterialPageList.getRows();
        String fileName = "\u5e73\u53f0\u7269\u6599-\u5bfc\u51fa\u6570\u636e";
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, PlatMaterial.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }
}

