import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/queryByUser`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 查询企业列表
export function dataEnterpriseList(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizEnterprise/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 获取考核配置分页
export function getEvaluationConfig(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierPerformanceEvaluationConfiguration/v1/query',data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 表格考核配置详情
export function getEvaluationConfigDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluationConfiguration/v1/getModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/userRating`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格详情
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluation/v1/getUserModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 查询评分供应商列表
export function dataSupplierList(evaluationId: string,detailsId: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluation/v1/getRatingUser?evaluationId=${evaluationId}&detailsId=${detailsId}`,)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
        
// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/updateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}


// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 查询当前评分人供应商汇总信息
export function dataSupplier(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/queryByPersonalSum`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 根据供应商查询评分明细
export function scoreDetail(evaluationId: string, supplierId: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluationRatingUser/v1/getSupplierScore?evaluationId=${evaluationId}&supplierId=${supplierId}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 保存评分信息
export function saveUserRating(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluationRatingUser/v1/batchUpdateForm`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 提交审核
export function saveAll(evaluationId: string) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/subUserRating?evaluationId=${evaluationId}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
