package com.artfess.portal.persistence.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.portal.params.ActuatorInfo;
import com.artfess.portal.params.TraceInfo;
import com.artfess.portal.persistence.manager.ActuatorSystemService;
import com.artfess.portal.util.HttpUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Redis 监控信息获取
 *
 * @Author MrBird
 */
@Service("actuatorSystemService")
@Slf4j
public class ActuatorSystemServiceImpl implements ActuatorSystemService {

    String ip;
    @Value(value = "${server.port}")
    private String port;



    {
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }


    @Override
    public List<TraceInfo> getHttpTrace() throws IOException {
        String httptrace = "http://" + ip + ":" + port + "/actuator/httptrace";
        List<TraceInfo> list = new ArrayList<>();
        String entity = HttpUtil.get(httptrace);
        System.out.println(entity);
        JSONArray jsonArray = JSONUtil.parseArray(JSONUtil.parseObj(entity).get("traces"));
        System.out.println(jsonArray);
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String timestamp = jsonObject.get("timestamp").toString().substring(0,jsonObject.get("timestamp").toString().indexOf("."));

            String timeTaken = jsonObject.get("timeTaken").toString()+"ms";

            JSONObject request = jsonObject.getJSONObject("request");

            String method = request.get("method").toString();

            String uri = request.get("uri").toString();

            JSONObject headers = request.getJSONObject("headers");




            String token = null;
            try {
                token = headers.get("proxy-authorization").toString();
            } catch (Exception e) {
                token = null;
            }

            String jsession = null;
            try {
                jsession = headers.get("cookie").toString();
            } catch (Exception e) {
                jsession = null;
            }


            if (StringUtils.isNotBlank(uri)) {
                uri = uri.replace("\"", "").replace("\"", "");
            }
            if (StringUtils.isNotBlank(method)) {
                method = method.replace("\"", "").replace("\"", "");
            }

            if (StringUtils.isNotBlank(jsession)) {
                jsession = jsession.split("; ")[0].replace("[\"", "").replace("\"]", "");
            }
            if (StringUtils.isNotBlank(token)) {
                token = token.replace("[\"", "").replace("\"]", "");
            }

            TraceInfo trace = new TraceInfo();
            trace.setJSESSIONID(jsession);
            trace.setMethod(method);
            trace.setTimestamp(timestamp);
            trace.setToken(token);
            trace.setUri(uri);
            trace.setTimeTaken(timeTaken);
            list.add(trace);
        }

       /* JsonNode jsonNode = JsonUtil.toJsonNode(entity).get("traces");
        for (int i = 0; i < jsonNode.size(); i++) {
            JsonNode node = jsonNode.get(i);
            System.out.println(node);

            String timestamp = node.get("timestamp").toString();
            String timeTaken = node.get("timeTaken").toString();
            JsonNode request = node.get("request");
            String method = request.get("method").toString();
            String uri = request.get("uri").toString();
            JsonNode headers = request.get("headers");

            String token = null;
            try {
                token = headers.get("x-access-token").toString();
            } catch (Exception e) {
                token = null;
            }
            String jsession = null;
            try {
                jsession = headers.get("cookie").toString();
            } catch (Exception e) {
                jsession = null;
            }

            if (StringUtils.isNotBlank(uri)) {
                uri = uri.replace("\"", "").replace("\"", "");
            }
            if (StringUtils.isNotBlank(method)) {
                method = method.replace("\"", "").replace("\"", "");
            }

            if (StringUtils.isNotBlank(jsession)) {
                jsession = jsession.split("; ")[0].replace("[\"", "").replace("\"]", "");
            }
            if (StringUtils.isNotBlank(token)) {
                token = token.replace("[\"", "").replace("\"]", "");
            }


            TraceInfo trace = new TraceInfo();
            trace.setJSESSIONID(jsession);
            trace.setMethod(method);
            trace.setTimestamp(timestamp);
            trace.setToken(token);
            trace.setUri(uri);
            trace.setTimeTaken(timeTaken);
            list.add(trace);
        }*/
        return list;
    }

    @Override
    public List<ActuatorInfo> getMetrics(String type) throws IOException {

        String metrics = "http://" + ip + ":" + port + "/actuator/metrics";
        String entity = HttpUtil.get(metrics);

        JsonNode jsonNode = JsonUtil.toJsonNode(entity).get("names");
        List<ActuatorInfo> infoList = new ArrayList<>();
        for (int i = 0; i < jsonNode.size(); i++) {

            JsonNode node = jsonNode.get(i);

            String jsonObject = node.toString();
            if (jsonObject.indexOf(type) == 1) {
                if (StringUtils.isNotBlank(jsonObject)) {
                    jsonObject = jsonObject.replace("\"", "").replace("\"", "");
                }
                ActuatorInfo actuatorInfo = new ActuatorInfo();
                String value = HttpUtil.get(metrics + "/" + jsonObject);

                //System.out.println(value);

                JsonNode measurements = JsonUtil.toJsonNode(value).get("measurements");

                // System.out.println(measurements.size());

                Object kv = JsonUtil.toMap(measurements.get(0).toString()).get("value");
                //System.out.println(kv);


                actuatorInfo.setKey(jsonObject);
                actuatorInfo.setValue(kv.toString());
                infoList.add(actuatorInfo);
            }
        }
        return infoList;
    }

    @Override
    public Map<String, String> getHealth() throws IOException {
        Map<String, String> map = new HashMap<>();
        String health = "http://" + ip + ":" + port + "/actuator/health";
        String entity = HttpUtil.get(health);
        if (StringUtils.isNotEmpty(entity)) {
            JsonNode jsonNode = JsonUtil.toJsonNode(entity);
            String systemStatus = jsonNode.get("status").toString();
            if (StringUtils.isNotBlank(systemStatus)) {
                systemStatus = systemStatus.replace("\"", "").replace("\"", "");
            }
            map.put("systemStatus", systemStatus);
            JsonNode node = jsonNode.get("components");
            Map<String, Map<String, Object>> moduleMap = JsonUtil.toMap(node.toString());

            for (String str : moduleMap.keySet()) {

                Map<String, Object> statusMap = moduleMap.get(str);

                map.put(str, statusMap.get("status").toString());
            }
        }


        return map;
    }

    /**
     * 开始分页
     *
     * @param list
     * @param pageNum  页码
     * @param pageSize 每页多少条数据
     * @return
     */
    public static List startPage(List list, Integer pageNum,
                                 Integer pageSize) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }

        Integer count = list.size(); // 记录总数
        Integer pageCount = 0; // 页数
        if (count % pageSize == 0) {
            pageCount = count / pageSize;
        } else {
            pageCount = count / pageSize + 1;
        }

        int fromIndex = 0; // 开始索引
        int toIndex = 0; // 结束索引

        if (pageNum != pageCount) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = count;
        }

        List pageList = list.subList(fromIndex, toIndex);

        return pageList;
    }
}
