package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.query.dao.BizQueryTagConditionDao;
import com.artfess.query.manager.BizQueryTagConditionManager;
import com.artfess.query.model.BizQueryTagCondition;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 按标签分类查询条件表（BIZ_QUERY_TAG_CONDITION） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryTagConditionManagerImpl extends BaseManagerImpl<BizQueryTagConditionDao, BizQueryTagCondition> implements BizQueryTagConditionManager {

    @Override
    public List<BizQueryTagCondition> qureyConditionByTag(String tagId) {
        Assert.hasText(tagId, "请选择标签");
        return this.baseMapper.qureyConditionByTag(tagId);
    }
}
