package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryTagConditionManager;
import com.artfess.query.model.BizQueryTagCondition;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.checkerframework.checker.units.qual.K;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 按标签分类查询条件表（BIZ_QUERY_TAG_CONDITION） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--按标签分类查询条件表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/tagCondition/v1/")
public class BizQueryTagConditionController extends BaseController<BizQueryTagConditionManager, BizQueryTagCondition> {

    @ApiOperation("批量保存按标签分类查询条件表")
    @PostMapping("saveBatchTagCondition")
    public CommonResult<String> saveBatchTagCondition(@ApiParam(name = "model",value = "实体信息")
                                             @RequestBody
                                             @Validated({AddGroup.class}) List<BizQueryTagCondition> tagList) throws Exception {
        boolean status = this.baseService.saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null,"批量保存按标签分类查询条件表成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("根据标签查询对应配置的条件信息")
    @PostMapping("qureyConditionByTag")
    public CommonResult<String> qureyConditionByTag(@RequestParam String tagId){
        List<BizQueryTagCondition> list = this.baseService.qureyConditionByTag(tagId);
        List<Map<String,Object>> reList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(list)){
            Map<String,List<BizQueryTagCondition>> map = list.stream().collect(Collectors.groupingBy(BizQueryTagCondition::getQueryCatalogs));
            for (Map.Entry<String, List<BizQueryTagCondition>> entry : map.entrySet()){
                String key = entry.getKey();
                List<BizQueryTagCondition> value = entry.getValue();
                Map<String,Object> result = new HashMap<>();
                result.put("group",key);
                result.put("size",value.size());
                result.put("data",value);
                result.put("sn",value.get(0).getSn());
                reList.add(result);
            }
            reList.sort(Comparator.comparing(
                    remap -> (Comparable) remap.get("sn"),
                    Comparator.nullsFirst(Comparator.naturalOrder())
            ));
        }
        return  CommonResult.success(reList,"获取成功！");
    }
}
