package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizAdvanceQueryMouldConfigManager;
import com.artfess.query.model.BizAdvanceQueryMould;
import com.artfess.query.model.BizAdvanceQueryMouldConfig;
import com.artfess.query.model.BizQueryTagCondition;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 高级查询条件配置表(界面动态配置）BIZ_ADVANCE_QUERY_MOULD_CONFIG 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--高级查询条件配置表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/queryMouldConfig/v1/")
public class BizAdvanceQueryMouldConfigController extends BaseController<BizAdvanceQueryMouldConfigManager, BizAdvanceQueryMouldConfig> {

    @ApiOperation("批量保存高级查询条件表")
    @PostMapping("saveBatch")
    public CommonResult<String> saveBatch(@ApiParam(name = "model",value = "实体信息")
                                             @RequestBody
                                             @Validated({AddGroup.class}) List<BizAdvanceQueryMouldConfig> tagList) throws Exception {
        //验证字段不能出现重复
        List<String> fields=tagList.stream().map(t->t.getFieldName()).collect(Collectors.toList());
        List<String> disFields=fields.stream().distinct().collect(Collectors.toList());
        if(fields.size()!=disFields.size()){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,"设置字段不能重复");
        }

        boolean status = this.baseService.saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null,"批量高级查询条件模板表成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("根据标签查询对应配置的高级查询条件信息")
    @PostMapping("qureyConditionByTag")
    public CommonResult<String> qureyConditionByTag(@RequestParam String tagId){
        List<BizAdvanceQueryMouldConfig> list = this.baseService.qureyConditionByTag(tagId);
        List<Map<String,Object>> reList = new ArrayList<>();
        if(!CollectionUtils.isEmpty(list)){
            Map<String,List<BizAdvanceQueryMouldConfig>> map = list.stream().collect(Collectors.groupingBy(BizAdvanceQueryMouldConfig::getQueryCatalogs));
            for (Map.Entry<String, List<BizAdvanceQueryMouldConfig>> entry : map.entrySet()) {
                String key = entry.getKey();
                List<BizAdvanceQueryMouldConfig> value = entry.getValue();
                Map<String,Object> result = new HashMap<>();
                result.put("group",key);
                result.put("data",value);
                result.put("size",value.size());
                result.put("sn",value.get(0).getSn());
                reList.add(result);
            }
            reList.sort(Comparator.comparing(
                    remap -> (Comparable) remap.get("sn"),
                    Comparator.nullsFirst(Comparator.naturalOrder())
            ));
        }
        return  CommonResult.success(reList,"获取成功！");
    }
}
