package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.query.manager.BizQueryTagCaseManager;
import com.artfess.query.model.BizQueryTagCase;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 搜索案例数据示意表【不同标签取10个即可】（BIZ_QUERY_TAG_CASE） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--搜索案例数据示意表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/tagCase/v1/")
public class BizQueryTagCaseController extends BaseController<BizQueryTagCaseManager, BizQueryTagCase> {


    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询条件")
    public PageList<BizQueryTagCase> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizQueryTagCase> queryFilter) {
        return baseService.query(queryFilter);
    }

}
