package com.artfess.dataShare.scheduler.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 定时任务  ---Shell作业 配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2024-12-17
 */
@ApiModel(value="BizSchedulerShellTask对象", description="定时任务  ---Shell作业 配置表")
@TableName("BIZ_SCHEDULER_SHELL_TASK")
public class BizSchedulerShellTask extends BaseModel<BizSchedulerShellTask> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "调度作业ID")
    @TableField("JOB_ID_")
    private String jobId;

    @ApiModelProperty(value = "调度作业名称")
    @TableField("JOB_NAME_")
    private String jobName;

    @ApiModelProperty(value = "SHELL命令执行地方（local：本地执行，remote：远程执行）")
    @TableField("JOB_MODE_")
    private String jobMode;

    @ApiModelProperty(value = "远程服务器IP和端口")
    @TableField("REMOTE_IP_")
    private String remoteIp;

    @ApiModelProperty(value = "远程服务器用户")
    @TableField("REMOTE_NAME_")
    private String remoteName;

    @ApiModelProperty(value = "远程服务器密码")
    @TableField("REMOTE_PWD_")
    private String remotePwd;

    @ApiModelProperty(value = "Shell文件名称")
    @TableField("SHELL_NAME_")
    private String shellName;

    @ApiModelProperty(value = "Shell文件路径")
    @TableField("SHELL_PATH_")
    private String shellPath;

    @ApiModelProperty(value = "shell命令代码内容")
    @TableField("COMMAND_")
    private String command;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobName() {
        return jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobMode() {
        return jobMode;
    }

    public void setJobMode(String jobMode) {
        this.jobMode = jobMode;
    }

    public String getRemoteIp() {
        return remoteIp;
    }

    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    public String getRemoteName() {
        return remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public String getRemotePwd() {
        return remotePwd;
    }

    public void setRemotePwd(String remotePwd) {
        this.remotePwd = remotePwd;
    }

    public String getShellName() {
        return shellName;
    }

    public void setShellName(String shellName) {
        this.shellName = shellName;
    }

    public String getShellPath() {
        return shellPath;
    }

    public void setShellPath(String shellPath) {
        this.shellPath = shellPath;
    }

    public String getCommand() {
        return command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizSchedulerShellTask{" +
            "id=" + id +
            ", jobId=" + jobId +
            ", jobName=" + jobName +
            ", jobMode=" + jobMode +
            ", remoteIp=" + remoteIp +
            ", remoteName=" + remoteName +
            ", remotePwd=" + remotePwd +
            ", shellName=" + shellName +
            ", shellPath=" + shellPath +
            ", command=" + command +
        "}";
    }
}
