package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 数据共享管理--共享资源表管理 （元数据信息+TABLE信息）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-22
 */
@ApiModel(value="BizShareTable对象", description="数据共享管理--共享资源表管理 （元数据信息+TABLE信息）")
@TableName("BIZ_SHARE_TABLE")
@Data
public class BizShareTable extends AutoOrgFillModel<BizShareTable> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "共享资源目录ID")
    @TableField("CATALOG_ID_")
    @NotBlank(message = "请选择目录！",groups = {AddGroup.class, UpdateGroup.class})
    private String catalogId;

    @ApiModelProperty(value = "共享数据资源名称")
    @TableField("NAME_")
    @NotBlank(message = "请填写共享数据资源名称！",groups = {AddGroup.class, UpdateGroup.class})
    private String name;

    @ApiModelProperty(value = "共享数据资源编码")
    @TableField("CODE_")
    @NotBlank(message = "请填写共享数据资源编码！",groups = {AddGroup.class, UpdateGroup.class})
    private String code;

    @ApiModelProperty(value = "共享数据资源描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "数据源别名")
    @TableField("DB_ALIAS_")
    private String dbAlias;

    @ApiModelProperty(value = "数据源ID")
    @TableField(exist = false)
    private String databaseId;

    @ApiModelProperty(value = "共享数据资源密级级别（1：低，2：中，3：较高，4：高）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "资源更新周期（仅一次，实时，每天，每周，每月，每季度，每年）")
    @TableField("UPDATE_RATE_")
    private String updateRate;

    @ApiModelProperty(value = "是否开启数据库提供方式（0：否，1：是）")
    @TableField("IS_DATABASE_")
    private String isDatabase;

    @ApiModelProperty(value = "是否开启API提供方式（0：否，1：是）")
    @TableField("IS_API_")
    private String isApi;

    @ApiModelProperty(value = "是否开启离线文件提供方式（0：否，1：是）")
    @TableField("IS_FILE_")
    private String isFile;

    @ApiModelProperty(value = "实体表中文名称")
    @TableField("TABLE_NAME_CH_")
    private String tableNameCh;

    @ApiModelProperty(value = "实体表英文名称")
    @TableField("TABLE_NAME_EN_")
    private String tableNameEn;

    @ApiModelProperty(value = "实体表描述")
    @TableField("TABLE_DESC_")
    private String tableDesc;

    @ApiModelProperty(value = "实体表_数据库表名(唯一)DWD_X_表英文名")
    @TableField("TABLE_CODE_")
    private String tableCode;

    @ApiModelProperty(value = "实体表创建状态（0：否，1：是）")
    @TableField("IS_CREATE_TABLE_")
    private String isCreateTable;

    @ApiModelProperty(value = "表创建SQL语句")
    @TableField("CREATE_TABLE_SQL_")
    private String createTableSql;

    @ApiModelProperty(value = "字段总数")
    @TableField("FIELD_TOTAL")
    private Integer fieldTotal;

    @ApiModelProperty(value = "表当前数据总量")
    @TableField("TOTAL_NUM_")
    private Integer totalNum;

    @ApiModelProperty(value = "增量采集源表时间戳字段名")
    @TableField("INCREMENT_TIMEKEY")
    private String incrementTimekey;

    @ApiModelProperty(value = "表数据更新方式（1：全量 2：增量）")
    @TableField("SYNC_TYPE_")
    private Integer syncType;

    @ApiModelProperty(value = "增量采集的最大时间戳值（用于记录从其它层表中获取增量数据的条件）")
    @TableField("INCREMENT_MAXTIME_")
    private Integer incrementMaxtime;

    @ApiModelProperty(value = "离线数据文件xls下载地址URL")
    @TableField("DATAFILE_DOWN_URL_")
    private String datafileDownUrl;

    @ApiModelProperty(value = "共享发布状态（0：下架，1：发布上线）")
    @TableField("DEPLOYED_STATUS_")
    private String deployedStatus;

    @ApiModelProperty(value = "发布日期")
    @TableField("DEPLOYED_TIME_")
    private LocalDateTime deployedTime;

    @ApiModelProperty(value = "共享发布人姓名")
    @TableField("DEPLOYED_USERNAME_")
    private String deployedUsername;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;

    @TableField(exist = false)
    List<BizShareTableField> tableFieldList;

    @TableField(exist = false)
    List<BizShareApi> apiList;

    @TableField(exist = false)
    List<BizShareFiles> filesList;
}
