package com.artfess.dataShare.dataShare.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.vo.RespParamVo;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.constraints.NotBlank;

/**
 * 数据资源-- 接口共享信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2024-12-03
 */
@ApiModel(value="BizShareApi对象", description="数据资源-- 接口共享信息")
@TableName("BIZ_SHARE_API")
@Data
public class BizShareApi extends AutoFillModel<BizShareApi> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "共享资源模型ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "接口名称")
    @TableField("API_NAME_")
    private String apiName;

    @NotBlank(message = "接口编码不能为空！", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "接口编码")
    @TableField("API_CODE_")
    private String apiCode;

    @ApiModelProperty(value = "接口描述")
    @TableField("API_DESC_")
    private String apiDesc;

    @ApiModelProperty(value = "接口地址")
    @TableField("API_URL_")
    private String apiUrl;

    @ApiModelProperty(value = "请求方式（POST、GET、DELETE、PUT）")
    @TableField("API_MODE_")
    private RequestMethod apiMode;

    @ApiModelProperty(value = "接口查询方式（0：不分页，1：分页）")
    @TableField("API_QUREY_TYPE_")
    private Integer apiQureyType;

    @ApiModelProperty(value = "数据源别名")
    @TableField("DB_ALIAS_")
    private String dbAlias;

    @ApiModelProperty(value = "SQL查询语句")
    @TableField("API_SQL_")
    private String apiSql;

    @ApiModelProperty(value = "请求头说明")
    @TableField("REQUEST_HEADER_")
    private String requestHeader;

    @ApiModelProperty(value = "请求参数说明")
    @TableField("REQUEST_PARAMS_")
    private String requestParams;

    @ApiModelProperty(value = "请求参数样例")
    @TableField("REQUEST_EXAMPLE_")
    private String requestExample;

    @ApiModelProperty(value = "响应状态码信息")
    @TableField("RESPONSE_STATUS_")
    private String responseStatus;

    @ApiModelProperty(value = "返回参数说明")
    @TableField("RESPONSE_PARAMS_")
    private String responseParams;

    @ApiModelProperty(value = "返回数据样例")
    @TableField("RESPONSE_EXAMPLE_")
    private String responseExample;

    @TableField(exist = false)
    private RespParamVo respParamVo;

    @ApiModelProperty(value = "接口状态（0：下架，1：正式）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    private String isDele;

    @TableField(exist = false)
    private BizShareTable table;
}
