package com.artfess.dataShare.dataResource.ods.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsTableDao;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsFieldManager;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsTableExportVo;
import com.artfess.dataShare.dataResource.ods.vo.CatalogTableVo;
import com.artfess.dataShare.dataResource.ods.vo.OdsTableDetailVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.Constants;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据资源--ODS数据项信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
@Service
public class BizOdsTableManagerImpl extends BaseManagerImpl<BizOdsTableDao, BizOdsTable> implements BizOdsTableManager {
    @Resource
    BizClusterTableManager clusterTableManager;

    @Resource
    BizClusterTableFieldManager clusterFieldManager;

    @Resource
    BizOdsTableManager odsTableManager;

    @Resource
    BizOdsFieldManager odsFieldManager;

    @Resource
    IdGenerator idGenerator;

    @Transactional(rollbackFor = Exception.class )
    public void saveTable(String catalogId,String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");

        //1、读取交换库的模型、表。字段
        BizClusterTable clusterTable = this.clusterTableManager.getById(tableId);
//        String tableName=clusterTable.getTableName();//.replace("ods_","dw_");
//        clusterTable.setTableName(tableName);
//        clusterTable.setCode(tableName);
//        BizClusterMould clusterMould = this.clusterMouldManager.getById(clusterTable.getMouldId());
//        List<BizClusterField> clusterFieldList = this.clusterFieldManager.queryFieldByTableId(tableId);
        List<BizClusterTableField> clusterFieldList = this.clusterFieldManager.queryFieldByTableId(tableId);
        //2、把数据写如到ods库的数据表
        //BizOdsMould odsMould=new BizOdsMould();
        BizOdsTable odsTable=new BizOdsTable();
        List<BizOdsField> odsFieldList = new ArrayList<>();
        String tableName="ods_"+clusterTable.getTableNameEn();
        //BeanUtils.copyNotNullProperties(odsMould,clusterMould);
        BeanUtils.copyNotNullProperties(odsTable,clusterTable);
        odsTable.setTableNameEn(tableName);
        odsTable.setId(idGenerator.getSuid());
        odsTable.setOdsCatalogsId(catalogId);
        odsTable.setTablePrefixCode(clusterTable.getTablePrefixCode());
        odsTable.setClusterTableId(clusterTable.getId());
        odsTable.setClusterId(clusterTable.getClusterId());
        odsTable.setDeployed(0);
        odsTable.setDeployedTime(null);
        odsTable.setIsCreateTable(0);
        odsTable.setTotalNum(clusterFieldList.size());
        odsTable.setDbSourceId(Constants.ODS_DATA_SOURCE_ALIAS);
        odsTable.setCreateTableSql(null);

        boolean flag = this.cheackSameClusterTable(clusterTable.getId(),odsTable.getId());
        if(flag){
            throw new ApplicationException("选中的汇聚层数据资源【"+clusterTable.getName()+"】已经被使用，不能再次使用！");
        }
        for(BizClusterTableField clusterField : clusterFieldList){
            BizOdsField odsField=new BizOdsField();
            BeanUtils.copyNotNullProperties(odsField,clusterField);
            odsField.setId(idGenerator.getSuid());
            odsField.setTableId(odsTable.getId());
            if("管理字段".equals(odsField.getFieldType())){
                odsField.setFieldType("1");
            }else if("业务字段".equals(odsField.getFieldType())){
                odsField.setFieldType("2");
            }
            if (BeanUtils.isEmpty(odsField.getFieldValueType())){
                odsField.setFieldValueType(1);
            }
            Integer attrLength=odsField.getAttrLength()==null ? 0 : odsField.getAttrLength();
            Integer decimalLen=odsField.getDecimalLen()==null ? 4 : odsField.getDecimalLen();
            String fieldSq="ALTER TABLE `"+tableName+"` ADD COLUMN `"+odsField.getFieldName()+"` "+ FieldUtil.getColumnType(odsField.getDataType(), attrLength, attrLength, decimalLen) +" NULL COMMENT '"+odsField.getDesc()+"' ";
            odsField.setFlSql(fieldSq);
            odsFieldList.add(odsField);
        }
        //生成下载地址
       /* Map<String,String> exportMap = new LinkedHashMap<>();
        for(BizOdsField field1 : odsFieldList){
            exportMap.put(field1.getName(), field1.getDesc());
        }*/
       /* // 拼装exprotMaps
        HSSFWorkbook book = ExcelUtil.exportExcel(odsTable.getName(), 12, exportMap, new ArrayList<>(), 0);
        //ExcelUtil.downloadExcel(book, odsTable.getName() + "_导入模板", response);
        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder(rootRealPath, true);
        String path = rootRealPath+File.separator+System.currentTimeMillis()+".xls";
        book.write(new File(path));*/
        odsTableManager.save(odsTable);
        odsFieldManager.saveBatch(odsFieldList);

        //3、在ods库里面创建表和字段  doris
        //JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dbAlias);
        //DorisUtils.createTable(template,clusterTable.getTableName(),odsFieldList);
    }

    @Override
    public boolean saveTableBatch(List<CatalogTableVo> list) throws Exception {
        for (CatalogTableVo entity : list) {
            saveTable(entity.getCatalogId(),entity.getTableId());
        }
        return true;
    }

    //发布的时候建表
    @Transactional(rollbackFor = Exception.class )
    public void Deploy(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        BizOdsTable table= this.getById(tableId);
        if("1".equals(table.getDeployed())){
            throw new ApplicationException("表已经发布，不能重复发布");
        }
        List<BizOdsField> fieldList = odsFieldManager.queryFieldByTableId(tableId);
        if(fieldList.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        //获取共享库数据源
        //JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias("ODS");
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        //3、在ods库里面创建表和字段  doris
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String createSql=DorisUtils.createTable(template,table.getTableNameEn(),tableDesc,fieldList);
        table.setCreateTableSql(createSql);
        this.update(table);
        //BizOdsCatalogs moduleType= this.odsCatalogsManager.getById(table.getOdsCatalogsId());
        //只同步表数据和字段数据到宏天，，不通过他建表
        //2014、12、15 laowang 不同步表到宏天去
        //SyncTableUtil.createOdsMouldAndTable(jdbcTemplate,template,table.getId(),table.getId(),table.getTableNameEn(),table.getCode(),table.getDescription(),Constants.ODS_DATA_SOURCE_ALIAS,fieldList,moduleType.getId(),moduleType.getName());
    }

    public OdsTableDetailVo queryTableVo(String tableId) throws Exception{
        Assert.notNull(tableId, "表ID不能为空");
        OdsTableDetailVo vo = new OdsTableDetailVo();
        BizOdsTable table=this.getById(tableId);
        if(null==table){
            throw new BaseException("未查询到表");
        }
        vo.setTable(table);
        vo.setFieldList(this.odsFieldManager.queryFieldByTableId(tableId));
        return vo;

    }

    //根据表下载导入模板
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizOdsTable odsTable = this.getById(tableId);
        List<BizOdsField> field=odsFieldManager.queryFieldByTableId(tableId);
        if(field.size()==0){
            throw new ApplicationException("资源表未设置字段。");
        }
        Map<String,String> exportMap = new LinkedHashMap<>();
        for(BizOdsField field1 : field){
            exportMap.put(field1.getName(), field1.getDesc());
        }
        // 拼装exprotMaps
        HSSFWorkbook book = ExcelUtil.exportExcel(odsTable.getName(), 12, exportMap, new ArrayList<>(), 0);
/*        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder(rootRealPath, true);
        String path = rootRealPath+File.separator+System.currentTimeMillis()+".xls";
        book.write(new File(path));
        dwTable.setDatafileDownUrl(path);*/
        ExcelUtil.downloadExcel(book, odsTable.getName() + "_导入模板", response);
        //book.write(new File("D:\\123.xlsx"));

    }

    //根据表和EXCEL导入数据到表
    @Override
    @Transactional(rollbackFor = Exception.class )
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizOdsTable table = this.getById(tableId);
        List<BizOdsField> fieldLists=odsFieldManager.queryFieldByTableId(tableId);
        Map<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizOdsField field : fieldLists) {//这里同注释的会被覆盖，所以要导入导出的不要出现相同的列注释
            nameFieldMap.put(field.getDesc(), field.getFieldName());
        }
        List<Map<String, String>> rows = ExcelUtil.ImportDate(file);
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        for (Map<String, String> row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");

            List<String> fields = new ArrayList<String>();
            List<String> values = new ArrayList<String>();
            fields.add(BizClusterTableField.PK_NAME);
            values.add("'" +UniqueIdUtil.getSuid()+ "'");
            for (Map.Entry<String, String> map : row.entrySet()) {
                //excel单元格有值才去拼接sql
                if (BeanUtils.isNotEmpty(map.getValue())) {
                    String key = map.getKey();
                    String field = this.getFieldName(key, fieldLists, nameFieldMap.get(key));
                    if("ID_".equalsIgnoreCase(field)){
                        continue;
                    }
                    fields.add(field);
                    //fields.add("F_"+field);
                    String dataType = this.getDataType(key, fieldLists, nameFieldMap.get(key));
                    if ("number".equals(dataType)) {
                        values.add(map.getValue());
                    } else {
                        values.add("'" + map.getValue() + "'");
                    }
                }

            }
            //加入额外的两个字段
            //fields.add("F_form_data_rev_");
            //values.add("0");

            sql.append(table.getTableNameEn());
            sql.append("(" + String.join(",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join(",", values) + ")");
            template.execute(sql.toString());
        }

    }

    private String getFieldName(String key, List<BizOdsField> columnList, String fieldName) {
        for (BizOdsField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getFieldName();
            }
        }
        return "";
    }

    private String getDataType(String key, List<BizOdsField> columnList, String fieldName) {
        for (BizOdsField boAtt : columnList) {
            if (boAtt.getDesc().equals(key) || boAtt.getName().equals(fieldName)) {
                return boAtt.getDataType();
            }
        }
        return "";
    }

    public List<BizOdsTable> queryDeployed(){
        QueryWrapper<BizOdsTable> queryWrapper= new QueryWrapper<>();
        queryWrapper.eq("DEPLOYED_",1);
        return this.list(queryWrapper);
    }

    public QueryResultData queryTableData (QueryParamVo queryParamVo) throws Exception{
        //Assert.hasText(queryParamVo.getTableId(),"表ID不能为空");
        if(StringUtil.isEmpty(queryParamVo.getTableId()) && StringUtil.isEmpty(queryParamVo.getTableName())){
            throw new ApplicationException("表ID或者表名不能为空");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties(queryParam,queryParamVo);
        BizOdsTable table= null;

        if(StringUtil.isNotEmpty(queryParam.getTableId())){
            table = this.getById(queryParam.getTableId());
        }else {
            QueryWrapper<BizOdsTable> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("TABLE_NAME_EN_", queryParamVo.getTableName());
            table = this.baseMapper.selectOne(queryWrapper);
        }

        if(table == null){
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizOdsField> fieldList = odsFieldManager.queryFieldByTableId(table.getId());
        //只提取业务字段
        Map<String,String> field = fieldList.stream().filter(p->"2".equals(p.getFieldType())).collect(Collectors.toMap(BizOdsField::getFieldName, p->p.getName()));
        //field.put("id_","主键");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);

        /*BizDatasourcesRelation dataSourcesRelation = dataSourceRelationManager.queryBizDataSourceByType(1);
        if(null==dataSourcesRelation){
            throw new BaseException("未查询到数据源");
        }
        //获取共享库数据源
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(dataSourcesRelation.getAlias());*/
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Transactional(rollbackFor = Exception.class )
    public void removeTable(String tableId) throws Exception {
        BizOdsTable table=this.getById(tableId);
        boolean exists = checkPhysicsTableExists(table.getTableNameEn());
        if (exists){
            //如果表已经发布，删除实体表
            if(table.getDeployed() == 1){
                String dropSql="drop table "+table.getTableNameEn();
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
                template.execute(dropSql);
            }
        }
        QueryWrapper<BizOdsField> queryWrapper=new QueryWrapper();
        queryWrapper.eq("TABLE_ID_",tableId);
        this.removeById(tableId);
        this.odsFieldManager.getBaseMapper().delete(queryWrapper);
    }

    private Boolean cheackSameClusterTable(String clusterTableId,String id){
        Assert.hasText(clusterTableId, "请选择关联的汇聚资源！");
        QueryWrapper<BizOdsTable> queryWrapper=new QueryWrapper();
        queryWrapper.eq("CLUSTER_TABLE_ID_", clusterTableId);
        queryWrapper.ne(StringUtil.isNotEmpty(id), "ID_",id);
        Integer num = this.baseMapper.selectCount(queryWrapper);
        if(num > 0){
            return true;
        }else{
            return false;
        }
    }

    @Transactional(rollbackFor = Exception.class )
    public void export(MultipartFile file, String catalogId) throws Exception {
        ExcelTool<BizOdsTableExportVo> util = new ExcelTool<>(BizOdsTableExportVo.class);
        List<BizOdsTableExportVo> list = util.importExcel(file.getInputStream(),3,4);
        list=list.stream().filter(p->StringUtils.isNotBlank(p.getTableNameEn())).collect(Collectors.toList());
        if(list.size()==0){
            throw new BaseException("表没有检测到需要导入的数据，注意中文名不能为空。");
        }
        //判断表名是否存在
        for(BizOdsTableExportVo vo : list){
            if(StringUtils.isBlank(vo.getTableNameCh())){
                continue;
            }
            if(StringUtils.isBlank(vo.getTableNameCh())){
                throw new BaseException("表"+vo.getName()+"中文名不能为空");
            }
            if(StringUtils.isBlank(vo.getTableNameEn())){
                throw new BaseException("表"+vo.getName()+"英文名不能为空");
            }
            if(checkTable(vo.getTableNameEn())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getCode()+")】已经存在");
            }
            if(checkTableCode(vo.getCode())){
                throw new BaseException("表【"+vo.getName()+"("+vo.getCode()+")】已经存在");
            }
        }
        for(BizOdsTableExportVo vo : list){
            if(StringUtil.isEmpty(vo.getCode())){
                continue;
            }
            //System.out.println(vo.toString());

            BizOdsTable table=vo.parseTable(vo);
           /* Map<String,String> idsMap=createMouldAndTable(vo.getName(),vo.getCode(),vo.getDesc(),"LOCAL");
            mould.setId(idsMap.get("defId"));
            table.setId(idsMap.get("tableId"));*/
            table.setDbSourceId(Constants.ODS_DATA_SOURCE_ALIAS);
            table.setOdsCatalogsId(catalogId);
            table.setIsCreateTable(0);
            table.setDeployed(0);
            table.setSource("1");
            table.setTableType("1");
            table.setTableNameEn("ods_"+table.getTableNameEn());
            this.create(table);
        }
    }

    public boolean checkTable(String tableName){
        QueryWrapper<BizOdsTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TABLE_NAME_EN_",tableName);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    public boolean checkTableCode(String code){
        QueryWrapper<BizOdsTable> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("CODE_",code);
        int count =this.count(queryWrapper);
        if(count>0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional
    public void deployHaveTable(String tableId) throws Exception {
        BizOdsTable table = this.get(tableId);
        if(1==table.getDeployed()){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        this.update(table);
    }

    @Override
    @Transactional
    public void deployDotHaveTable(String tableId,String tableSql) throws Exception {
        BizOdsTable table = this.get(tableId);
        List<BizOdsField> odsFields = odsFieldManager.queryFieldByTableId(tableId);
        if(1==table.getDeployed()){
            throw new ApplicationException("表已经发布，不能从重复，如果有问题请联系管理员");
        }
        if(odsFields.size()==0){
            throw new ApplicationException("表内没有字段不能发布");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());

        template.execute(table.getCreateTableSql());
        this.update(table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception{
        tableNameEn="ods_"+tableNameEn.replaceFirst("dw_","");
        //查询表库是否存在
        if(checkTable(tableNameEn)){
            return true;
        }
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        //查询数据库是否存在
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias(Constants.ODS_DATA_SOURCE_ALIAS);
        String sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'";
        return template.queryForObject(sql, Integer.class) > 0 ? true : false;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = baseMapper.updateCatalog(ids,catalogId);
        return count > 0 ? true : false;
    }
}
