package com.artfess.dataShare.dataResource.ods.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsFieldManager;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据资源-- ODS字段信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-13
 */
@RestController
@Api(tags = "数据资源-- ODS字段信息")
@RequestMapping("/biz/dataResource/odsField/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_DATASHARE})
public class BizOdsFieldController extends BaseController<BizOdsFieldManager, BizOdsField> {

    @Resource
    BizOdsFieldManager fieldManager;

    @PostMapping("/importFile")
    @ApiOperation(value = "导入数据字段信息", httpMethod = "POST", notes = "导入数据字段信息")
    public CommonResult<String> export(@RequestParam(value = "file", required = true) MultipartFile file, String tableId) throws Exception {
        this.fieldManager.export(file,tableId);
        return new CommonResult<String>(true, "导入数据字段信息成功");
    }

    @PostMapping("/saveOrUpdates")
    @ApiOperation(value = "批量维护数据字段信息-单独保存字段，全度需要在每个字段里面加上tableId", httpMethod = "POST", notes = "保持数据字段信息")
    public CommonResult<String> saveTableField(@RequestBody List<BizOdsField> field) throws Exception {
        fieldManager.saveOrUpdates(field);
        return new CommonResult<String>(true, "批量维护数据字段信息");
    }

    @PostMapping("/saveOrUpdateFields")
    @ApiOperation(value = "修改发布后的表字段信息-同时要修改实体表", httpMethod = "POST", notes = "修改发布后的表字段信息-同时要修改实体表")
    public CommonResult<String> saveOrUpdateFields(@RequestBody List<BizOdsField> field) throws Exception {
        this.fieldManager.saveOrUpdateFields(field);
        return new CommonResult<String>(true, "修改成功");
    }
}
