package com.artfess.dataShare.dataCollect.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.QueryFilter;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.dataResource.ods.vo.CopyTableVo;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 数据汇聚表信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author WH
 * @since 2024-11-07
 */
public interface BizClusterTableManager extends BaseManager<BizClusterTable> {

    /**
     * 批量导入数据资源项目录清单
     * 读取到数据后同时生成【数据汇聚模型信息】和【数据汇聚表信息】两个表
     * 同时往宏天的下列表写入数据
     * 实体表  form_bo_ent
     * 实体字段表  form_field
     * 实体字段属性表 form_bo_attr
     * 业务模型 form_bo_def
     *
     * 修改form_bo_def表 增加数据源别名
     *
     * @param file
     */
    void export(MultipartFile file,String clusterInfoId) throws Exception;

    /**
     * 发布的时候建表
     */
    void Deploy(String tableId) throws Exception;

    /**
     * 保存查询表信息、字段信息、模型
     */
    void saveTableVo(TableDetailVo vo);

    /**
     * 根据表查询表信息、字段信息、模型
     * @return
     * @throws Exception
     */
    TableDetailVo queryTableVo(String tableId) throws Exception;

    /**
     * 手动建表
     */
    void createdTable(String tableId) throws Exception;

    /**
     * 手动建触发器
     */
    void createdTrigger(String tableId) throws Exception;

    /**
     * 查询触发器SQl
     */
    List<Map<String,String>> queryTriggerSql(String tableId) throws Exception;

    /**
     * 查询触发器SQla
     */
    String queryTableSql(String tableId) throws Exception;

    /**
     * 数据查询  分页，加搜索、排序
     * @param queryParam
     * @return
     * @throws Exception
     */
    QueryResultData queryTableData (QueryParamVo queryParam) throws Exception;

    /**
     * 查询所有发布了的表
     * @return
     */
    List<BizClusterTable> queryDeployed();

    /**
     * 下载用于导入bo主表的excel模板
     *
     * @param response
     * @param tableId    数据模板的别名
     * @throws IOException
     * @throws Exception
     */
    void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception;

    /**
     * 导入主表数据
     *
     * @throws Exception
     */
    void importMain(MultipartFile file, String tableId) throws Exception;

    /**
     * 查询一个汇聚方下面的全部表
     *
     * @throws Exception
     */
    List<BizClusterTable> queryTableByClusterId(String clusterId) throws Exception;

    /**
     * 数据汇聚表信息（分页）
     *
     * @param queryFilter
     * @return
     * @throws Exception
     */
    IPage<BizClusterTable> getClusterTableQueryList(QueryFilter<BizClusterTable> queryFilter) throws Exception;

    /**
     *  已有表发布
     * @param tableId 表ID
     * @param createTrigger 是否创建触发器
     * @throws Exception
     */
    void deployHaveTable(String tableId,String createTrigger) throws Exception;

    /**
     *  未有表发布
     * @param tableId 表ID
     * @param tableSql 建表语句
     * @param createTrigger 是否创建触发器
     * @throws Exception
     */
    void deployDotHaveTable(String tableId,String tableSql,String createTrigger) throws Exception;

    /**
     *  引用/复制创建ods层的其他表
     * @param vo 表ID
     * @throws Exception
     */
    void copyTable(CopyTableVo vo) throws Exception;

    /**
     * 验证表示已经创建
     * @param tableNameEn
     * @return
     * @throws Exception
     */
    boolean checkTableExists(String clusterId,String tableNameEn) throws Exception;

    /**
     * 如果表已经创建同步删除实体表
     * @param tableId
     */
    void removeTable(String tableId) throws Exception;

    /**
     * 验证物理表是否已经存在
     * @param clusterId
     * @param tableNameEn
     * @return
     */
    boolean checkPhysicsTableExists(String clusterId, String tableNameEn) throws Exception;
}
