package com.artfess.dataShare.algorithm.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 算法推理管理----算法推理信息管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@ApiModel(value="BizAlgorithmTaskinfo对象", description="算法推理管理----算法推理信息管理表")
public class BizAlgorithmTaskinfo extends AutoFillModel<BizAlgorithmTaskinfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "算法推理编码（唯一值）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "算法推理名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "推理任务理论描述（富文本框组件）")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "算法任务状态（1:待推理 2:推理完成4:发布生效5:失效）")
    @TableField("DEPLOYED_STATUS_")
    private String deployedStatus;

    @ApiModelProperty(value = "DS任务工作流编号")
    @TableField("ROUTINE_CODE_")
    private String routineCode;

    @ApiModelProperty(value = "DS任务工作流名称")
    @TableField("ROUTINE_NAME_")
    private String routineName;

    @ApiModelProperty(value = "算法任务发布当前版本号")
    @TableField("DEPLOYED_VERSION_")
    private String deployedVersion;

    @ApiModelProperty(value = "算法任务发布时间")
    @TableField("DEPLOYED_TIME_")
    private LocalDateTime deployedTime;

    @ApiModelProperty(value = "算法任务发布人姓名")
    @TableField("DEPLOYED_USERNAME_")
    private String deployedUsername;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "删除标记（1已删除，0未删除）")
    @TableField("IS_DELE_")
    @TableLogic
    private String isDele;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getDeployedStatus() {
        return deployedStatus;
    }

    public void setDeployedStatus(String deployedStatus) {
        this.deployedStatus = deployedStatus;
    }

    public String getRoutineCode() {
        return routineCode;
    }

    public void setRoutineCode(String routineCode) {
        this.routineCode = routineCode;
    }

    public String getRoutineName() {
        return routineName;
    }

    public void setRoutineName(String routineName) {
        this.routineName = routineName;
    }

    public String getDeployedVersion() {
        return deployedVersion;
    }

    public void setDeployedVersion(String deployedVersion) {
        this.deployedVersion = deployedVersion;
    }

    public LocalDateTime getDeployedTime() {
        return deployedTime;
    }

    public void setDeployedTime(LocalDateTime deployedTime) {
        this.deployedTime = deployedTime;
    }

    public String getDeployedUsername() {
        return deployedUsername;
    }

    public void setDeployedUsername(String deployedUsername) {
        this.deployedUsername = deployedUsername;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAlgorithmTaskinfo{" +
            "id=" + id +
            ", code=" + code +
            ", name=" + name +
            ", memo=" + memo +
            ", deployedStatus=" + deployedStatus +
            ", routineCode=" + routineCode +
            ", routineName=" + routineName +
            ", deployedVersion=" + deployedVersion +
            ", deployedTime=" + deployedTime +
            ", deployedUsername=" + deployedUsername +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", tenantId=" + tenantId +
        "}";
    }
}
