package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmVersionDao;
import com.artfess.dataShare.algorithm.manager.*;
import com.artfess.dataShare.algorithm.model.*;
import com.artfess.dataShare.algorithm.vo.TaskVersionVo;
import com.artfess.dataShare.util.YouBianCodeUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 算法推理管理----算法推理任务版本管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
@Service
public class BizAlgorithmVersionManagerImpl extends BaseManagerImpl<BizAlgorithmVersionDao, BizAlgorithmVersion> implements BizAlgorithmVersionManager {

    @Resource
    BizAlgorithmReasonManager reasonManager;

    @Resource
    BizAlgorithmRelationManager relationManager;

    @Resource
    BizAlgorithmVersionDao versionDao;

    @Transactional
    public void saveTaskVersion(TaskVersionVo vo) throws Exception{
        BizAlgorithmVersion version =vo.getVersion();
        //如果是另存为
        if(1==vo.getSaveAS()){
            //String versionNewCode=getNewVersionCode(version.getId());
            //逻辑推理编排表
            List<BizAlgorithmReason> reasons= this.reasonManager.queryByVersionId(version.getId());
            String newId= UniqueIdUtil.getSuid();
            version.setId(newId);
            //version.setVersionName(versionName);
            //version.setVersionCode(versionNewCode);
            this.save(version);

            Map<String,String> idMaps=new HashMap<>();
            for(BizAlgorithmReason item : reasons){
                String oldId=item.getId();
                item.setId(null);
                item.setTaskVersonId(newId);
                if(null!=idMaps.get(item.getParentId())){
                    item.setParentId(idMaps.get(item.getParentId()));
                }else{
                    item.setParentId("-1");
                }
                reasonManager.saveReason(item);
                idMaps.put(oldId,item.getId());
            }
        }else {
            if(null==version){
                List<BizAlgorithmReason> reasons = vo.getReasonList();
                for (BizAlgorithmReason item : reasons) {
                    reasonManager.saveReason(item);
                }
            }else {
                //保存版本信息
                saveOrUpdate(version);
                //BizAlgorithmVersion version=vo.getVersion();
                String versionId = version.getId();
                String taskId = version.getTaskId();
                //指标逻辑关系表
                List<BizAlgorithmReason> reasons = vo.getReasonList();
                for (BizAlgorithmReason item : reasons) {
                    item.setTaskId(taskId);
                    item.setTaskVersonId(versionId);
                    reasonManager.saveReason(item);

            /*List<BizAlgorithmRelation> relationList= item.getRelationList();
            if(null!=relationList){
                for(BizAlgorithmRelation algorithmRelation : relationList) {
                    algorithmRelation.setTaskVersonId(versionId);
                    algorithmRelation.setTaskId(taskId);
                    algorithmRelation.setCurrentIndexId(item.getId());
                    algorithmRelation.setCurrentIndexCode(item.getCode());
                    algorithmRelation.setCurrentIndexName(item.getName());
                }
                relationManager.saveOrUpdateBatch(relationList);
            }*/

                }
            }
            //算法指标关系说明表
        /*List<BizAlgorithmRelation> relationList= vo.getRelationList();
        for(BizAlgorithmRelation item : relationList){
            item.setTaskVersonId(versionId);
        }*/
            //算法指标计算公式说明配置表
        /*List<BizAlgorithmCompute> computeList= vo.getComputeList();
        for(BizAlgorithmCompute item : computeList){
            item.setTaskVersonId(versionId);
        }
        //relationManager.saveOrUpdateBatch(relationList);
        computeManager.saveOrUpdateBatch(computeList);*/
        }
    }

    public TaskVersionVo queryVersion(String id) throws Exception{
        //保存版本信息
        BizAlgorithmVersion version=this.getById(id);
        //算法指标关系说明表
        //List<BizAlgorithmRelation> relationList= this.relationManager.queryByVersionId(id);
        //逻辑推理编排表
        List<BizAlgorithmReason> reasons= this.reasonManager.queryByVersionId(id);
        //算法指标计算公式说明配置表
        //List<BizAlgorithmCompute> computeList= this.computeManager.queryByVersionId(id);
        TaskVersionVo vo=new TaskVersionVo();
        vo.setVersion(version);
        //vo.setComputeList(computeList);
        vo.setReasonList(reasons);
        //vo.setRelationList(relationList);
        return vo;
    }

    public String getNewVersionCode(String id) throws Exception{
        String maxVersionCode=this.versionDao.getMaxVersionCode(id);
        if(StringUtil.isEmpty(maxVersionCode)){
            return "1.0";
        }
        return YouBianCodeUtil.getNewMaxCode(maxVersionCode);
    }

    @Transactional
    public String saveAsTaskVersion(String versionId) throws Exception{
        //复制版本信息
        BizAlgorithmVersion version= this.getById(versionId);
        if(null==version){
            throw new ApplicationException("未查询到任务版本。");
        }
        String newId= UniqueIdUtil.getSuid();
        version.setId(newId);
        version.setVersionCode(getNewVersionCode(version.getTaskId()));
        this.save(version);

        //逻辑推理编排表
        List<BizAlgorithmReason> reasons= this.reasonManager.queryByVersionId(versionId);
        Map<String,String> idMaps=new HashMap<>();
        for(BizAlgorithmReason item : reasons){
            String oldId=item.getId();
            item.setId(null);
            item.setTaskVersonId(newId);
            if(null!=idMaps.get(item.getParentId())){
                item.setParentId(idMaps.get(item.getParentId()));
            }else{
                item.setParentId("-1");
            }
            reasonManager.saveReason(item);
            idMaps.put(oldId,item.getId());
        }
        return newId;
    }
}
