package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.dataShare.algorithm.model.BizAlgorithmCompute;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmComputeDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmComputeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 算法推理管理----算法指标计算公式说明配置表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-15
 */
@Service
public class BizAlgorithmComputeManagerImpl extends BaseManagerImpl<BizAlgorithmComputeDao, BizAlgorithmCompute> implements BizAlgorithmComputeManager {

    @Override
    public List<BizAlgorithmCompute> queryByVersionId(String versionId) {
        QueryWrapper<BizAlgorithmCompute> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("TASK_VERSON_ID",versionId);
        return this.list(queryWrapper);
    }
}
