package com.artfess.dataShare.algorithm.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.vo.TaskReasonVo;

import java.util.List;

/**
 * 算法推理管理----逻辑推理编排表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 系统管理员
 * @since 2025-01-08
 */
public interface BizAlgorithmReasonManager extends BaseManager<BizAlgorithmReason> {

    /**
     *  保存逻辑推理编排表
     * @param reason
     */
    void saveReason(BizAlgorithmReason reason);

    /**
     * 根据版本Id查询配置
     * @return
     */
    List<BizAlgorithmReason> queryByVersionId(String versionId);

    /**
     * 根据版本Id查询配置
     * @return
     */
    List<BizAlgorithmReason> queryByTypeAndVersionId(String versionId,Integer type);

    /**
     * 根据版本Id查询配置树
     * @return
     */
    List<BizAlgorithmReason> queryTreeByVersionId(String versionId);

    /**
     * 树形查询
     * @param entity
     * @return
     */
    List<BizAlgorithmReason> getTree(BizAlgorithmReason entity);

    /**
     * 查询指标推理表格查询说明
     * @param
     * @return
     */
    List<TaskReasonVo> queryTaskAndReason(String indexId,String type);

    /**
     * 指标推理表格查询和导出说明
     * @param indexId
     * @return
     */
    String exportTaskAndReason(String indexId,String type);

    /**
     *  只传任务ID就查询最新版本的编排，传了版本就查询对应的版本
     * @param taskId
     * @param versionId
     * @return
     */
    List<BizAlgorithmReason> queryReason(String taskId,String versionId);
}
