/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.mail.util;

import com.artfess.base.exception.SystemException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.mail.api.AttacheHandler;
import com.artfess.mail.model.Mail;
import com.artfess.mail.model.MailAddress;
import com.artfess.mail.model.MailAtt;
import com.artfess.mail.model.MailAttachment;
import com.artfess.mail.model.MailLing;
import com.artfess.mail.model.MailSetting;
import com.sun.mail.imap.IMAPFolder;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Security;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.UIDFolder;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.SearchTerm;
import javax.mail.util.ByteArrayDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    protected static Logger logger = LoggerFactory.getLogger(MailUtil.class);
    FileManager fileManager = (FileManager)AppUtil.getBean(FileManager.class);
    private MailSetting mailSetting;
    private AttacheHandler handler;
    private static final String CHARSET = "utf-8";

    public MailUtil(MailSetting mailSetting) {
        this.mailSetting = mailSetting;
    }

    public MailUtil() {
    }

    public void connectSmtpAndReceiver() throws MessagingException {
        this.connectSmtp();
        this.connectReciever();
    }

    public void connectSmtp() throws MessagingException {
        Session session = this.getMailSession("smtp");
        try (Transport transport = null;){
            transport = session.getTransport("smtp");
            transport.connect(this.mailSetting.getSendHost(), this.mailSetting.getMailAddress(), this.mailSetting.getPassword());
        }
    }

    public void connectReciever() throws MessagingException {
        Session session = this.getMailSession(this.mailSetting.getProtocal());
        URLName urln = new URLName(this.mailSetting.getProtocal(), this.mailSetting.getReceiveHost(), Integer.parseInt(this.mailSetting.getReceivePort()), null, this.mailSetting.getMailAddress(), this.mailSetting.getPassword());
        try (Store store = null;){
            store = session.getStore(urln);
            store.connect();
        }
    }

    public void send(Mail mail) throws Exception {
        Session session = this.getMailSession("smtp");
        MimeMessage message = new MimeMessage(session);
        this.addAddressInfo(mail, (Message)message, null);
        MimeBodyPart contentPart = new MimeBodyPart();
        MimeMultipart multipart = new MimeMultipart();
        contentPart.setHeader("Content-Transfer-Encoding", "base64");
        contentPart.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
        message.setSubject(mail.getSubject(), CHARSET);
        message.setText(CHARSET, CHARSET);
        message.setSentDate(new Date());
        multipart.addBodyPart((BodyPart)contentPart);
        message.setContent((Multipart)multipart);
        for (MailAttachment attachment : mail.getMailAttachments()) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            Object source = null;
            DefaultFile sysFile = (DefaultFile)this.fileManager.get((Serializable)((Object)attachment.getId()));
            if ("folder".equals(sysFile.getStoreType())) {
                String filePath = attachment.getFilePath();
                source = filePath == null || "".equals(filePath) ? new ByteArrayDataSource(attachment.getFileBlob(), "application/octet-stream") : new FileDataSource(new File(filePath));
            } else if (!"ftp".equals(sysFile.getStoreType()) && !"aliyunOss".equals(sysFile.getStoreType())) {
                byte[] fileBlob = sysFile.getBytes();
                source = new ByteArrayDataSource(fileBlob, "application/octet-stream");
            }
            messageBodyPart.setDataHandler(new DataHandler(source));
            messageBodyPart.setFileName(MimeUtility.encodeWord((String)attachment.getFileName(), (String)CHARSET, (String)"Q"));
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        Transport transport = session.getTransport("smtp");
        transport.connect(this.mailSetting.getSendHost(), this.mailSetting.getMailAddress(), EncryptUtil.decrypt((String)this.mailSetting.getPassword()));
        transport.sendMessage((Message)message, message.getAllRecipients());
    }

    public void send(Mail mail, MailSetting mailSet) throws Exception {
        mailSet.setSendHost(mailSet.getSmtpHost());
        mailSet.setSendPort(mailSet.getSmtpPort());
        Session session = this.getMailSession("smtp", mailSet);
        MimeMessage message = new MimeMessage(session);
        this.addAddressInfo(mail, (Message)message, mailSet);
        MimeBodyPart contentPart = new MimeBodyPart();
        MimeMultipart multipart = new MimeMultipart();
        contentPart.setHeader("Content-Transfer-Encoding", "base64");
        contentPart.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
        message.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)mail.getSenderAddress()));
        message.setSubject(mail.getSubject(), CHARSET);
        message.setText(CHARSET, CHARSET);
        message.setSentDate(new Date());
        multipart.addBodyPart((BodyPart)contentPart);
        message.setContent((Multipart)multipart);
        for (MailAttachment attachment : mail.getMailAttachments()) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            Object source = null;
            String filePath = attachment.getFilePath();
            source = filePath == null || "".equals(filePath) ? new ByteArrayDataSource(attachment.getFileBlob(), "application/octet-stream") : new FileDataSource(new File(filePath));
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(MimeUtility.encodeWord((String)attachment.getFileName(), (String)CHARSET, (String)"Q"));
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        Transport transport = session.getTransport("smtp");
        transport.connect(mailSet.getSendHost(), mailSet.getMailAddress(), mailSet.getPassword());
        transport.sendMessage((Message)message, message.getAllRecipients());
    }

    public void sendEmail(MailLing mail) throws UnsupportedEncodingException, MessagingException {
        Session session = this.getMailSession("smtp");
        MimeMessage message = new MimeMessage(session);
        this.addEmailAddressInfo(mail, (Message)message, null);
        MimeBodyPart contentPart = new MimeBodyPart();
        MimeMultipart multipart = new MimeMultipart();
        contentPart.setHeader("Content-Transfer-Encoding", "base64");
        contentPart.setContent((Object)mail.getContent(), "text/html;charset=utf-8");
        message.setSubject(mail.getSubject(), CHARSET);
        message.setText(CHARSET, CHARSET);
        message.setSentDate(new Date());
        multipart.addBodyPart((BodyPart)contentPart);
        message.setContent((Multipart)multipart);
        List<MailAtt> attachments = mail.getAttachments();
        if (BeanUtils.isNotEmpty(attachments)) {
            for (MailAtt attachment : attachments) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                Object source = null;
                DefaultFile defaultFile = (DefaultFile)this.fileManager.get((Serializable)((Object)attachment.getFileId()));
                String filePath = defaultFile.getFilePath();
                source = filePath == null || "".equals(filePath) ? new ByteArrayDataSource(defaultFile.getBytes(), "application/octet-stream") : new FileDataSource(new File(filePath));
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(MimeUtility.encodeWord((String)attachment.getFileName(), (String)CHARSET, (String)"Q"));
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        Transport transport = session.getTransport("smtp");
        transport.connect(this.mailSetting.getSendHost(), this.mailSetting.getMailAddress(), this.mailSetting.getPassword());
        transport.sendMessage((Message)message, message.getAllRecipients());
    }

    public List<Mail> receive(AttacheHandler handler) throws Exception {
        return this.receive(handler, "");
    }

    public List<Mail> receive(AttacheHandler handler, String lastHandleMessageId) throws Exception {
        this.handler = handler;
        Store connectedStore = this.getConnectedStore();
        Folder folder = this.getFolder(connectedStore);
        try {
            List<Mail> list = this.getMessages(folder, lastHandleMessageId);
            return list;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            this.close(folder, connectedStore);
        }
    }

    public Mail getByMessageID(AttacheHandler handler, String messageID) throws Exception {
        MessageIDTerm searchTerm;
        this.handler = handler;
        Store connectedStore = this.getConnectedStore();
        Folder folder = this.getFolder(connectedStore);
        Message[] messages = folder.search((SearchTerm)(searchTerm = new MessageIDTerm(messageID)));
        if (messages == null || messages.length == 0) {
            return null;
        }
        ArrayList<Mail> mailList = new ArrayList<Mail>();
        this.buildMailList(messageID, (MimeMessage)messages[0], mailList);
        return (Mail)((Object)mailList.get(0));
    }

    private Store getConnectedStore() throws MessagingException, Exception {
        Session session = this.getMailSession(this.mailSetting.getProtocal());
        URLName urln = new URLName(this.mailSetting.getProtocal(), this.mailSetting.getReceiveHost(), Integer.parseInt(this.mailSetting.getReceivePort()), null, this.mailSetting.getMailAddress(), this.mailSetting.getPassword());
        Store store = session.getStore(urln);
        store.connect();
        return store;
    }

    private Folder getFolder(Store store) throws MessagingException {
        Folder folder = store.getFolder("INBOX");
        if (this.mailSetting.getIsDeleteRemote().booleanValue()) {
            folder.open(2);
        } else {
            folder.open(1);
        }
        return folder;
    }

    private List<Mail> getMessages(Folder folder, String lastHandleMessageId) throws Exception {
        Message[] messages = null;
        FetchProfile profile = new FetchProfile();
        profile.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        folder.fetch(messages, profile);
        int total = folder.getMessageCount();
        List<Mail> mailList = new ArrayList<Mail>();
        boolean isLastHandleMessageIdNotEmpty = lastHandleMessageId != null && !"".equals(lastHandleMessageId.trim());
        mailList = this.getMessages(folder, lastHandleMessageId, mailList, isLastHandleMessageIdNotEmpty, total);
        return mailList;
    }

    private List<Mail> getMessages(Folder folder, String lastHandleMessageId, List<Mail> mailList, boolean isLastHandleMessageIdNotEmpty, int endIndex) throws Exception {
        MimeMessage msg = null;
        int begin = endIndex;
        int end = 1;
        try {
            if (folder instanceof IMAPFolder) {
                begin = endIndex - 1;
                end = 0;
            }
            for (int i = begin; i >= end; --i) {
                msg = (MimeMessage)folder.getMessage(i);
                if (!BeanUtils.isNotEmpty((Object)msg)) continue;
                String messageId = msg.getMessageID();
                if (!(StringUtil.isNotEmpty((String)messageId) && isLastHandleMessageIdNotEmpty && messageId.equals(lastHandleMessageId))) {
                    this.buildMailList(messageId, msg, mailList);
                    continue;
                }
                break;
            }
        }
        catch (FolderClosedException closeException) {
            folder = this.getFolder(folder.getStore());
            this.getMessages(folder, lastHandleMessageId, mailList, isLastHandleMessageIdNotEmpty, endIndex - mailList.size());
        }
        Collections.reverse(mailList);
        return mailList;
    }

    private void buildMailList(String messageId, MimeMessage message, List<Mail> list) throws Exception {
        if (this.handler.isDownlad(messageId) == null || !this.handler.isDownlad(messageId).booleanValue()) {
            return;
        }
        Mail mail = this.getMail(message);
        mail.setMessageId(messageId);
        list.add(mail);
        if (this.mailSetting.getIsDeleteRemote().booleanValue() && this.mailSetting.getIsHandleAttach().booleanValue()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private Mail getMail(MimeMessage message) throws Exception {
        Mail mail = new Mail();
        LocalDateTime sentDate = null;
        if (message.getSentDate() != null) {
            Date d = message.getSentDate();
            Instant instant = d.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            sentDate = LocalDateTime.ofInstant(instant, zone);
        } else {
            sentDate = LocalDateTime.now();
        }
        mail.setSendDate(sentDate);
        String subject = message.getSubject();
        if (subject != null) {
            mail.setSubject(MimeUtility.decodeText((String)subject));
        } else {
            mail.setSubject("\u65e0\u4e3b\u9898");
        }
        StringBuffer bodytext = new StringBuffer();
        this.getMailContent((Part)message, bodytext, mail);
        String content = bodytext.toString();
        if (StringUtil.isNotEmpty((String)content)) {
            content = Base64.getBase64((String)content);
        }
        mail.setContent(content);
        MailAddress temp = this.getFrom(message);
        mail.setSenderAddress(temp.getAddress());
        mail.setSenderName(temp.getName());
        temp = this.getMailAddress(Message.RecipientType.TO, message);
        mail.setReceiverAddresses(temp.getAddress());
        mail.setReceiverName(temp.getName());
        temp = this.getMailAddress(Message.RecipientType.BCC, message);
        mail.setBcCAddresses(temp.getAddress());
        mail.setBccName(temp.getName());
        temp = this.getMailAddress(Message.RecipientType.CC, message);
        mail.setCopyToAddresses(temp.getAddress());
        mail.setCopyToName(temp.getName());
        return mail;
    }

    private MailAddress getFrom(MimeMessage mimeMessage) throws Exception {
        MailAddress mailAddress = new MailAddress();
        try {
            InternetAddress[] address = (InternetAddress[])mimeMessage.getFrom();
            if (address == null || address.length == 0) {
                return mailAddress;
            }
            mailAddress.setAddress(address[0].getAddress());
            mailAddress.setName(address[0].getPersonal());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mailAddress;
    }

    private MailAddress getMailAddress(Message.RecipientType recipientType, MimeMessage mimeMessage) throws Exception {
        MailAddress mailAddress = new MailAddress();
        InternetAddress[] address = (InternetAddress[])mimeMessage.getRecipients(recipientType);
        if (address == null) {
            return mailAddress;
        }
        StringBuffer addresses = new StringBuffer("");
        StringBuffer name = new StringBuffer("");
        block3: for (int i = 0; i < address.length; ++i) {
            String email = address[i].getAddress();
            if (email == null) continue;
            String personal = address[i].getPersonal();
            if (personal == null) {
                personal = email;
            }
            switch (i) {
                case 0: {
                    addresses.append(MimeUtility.decodeText((String)email));
                    name.append(MimeUtility.decodeText((String)personal));
                    continue block3;
                }
                default: {
                    addresses.append(",").append(MimeUtility.decodeText((String)email));
                    name.append(",").append(MimeUtility.decodeText((String)personal));
                }
            }
        }
        mailAddress.setAddress(addresses.toString());
        mailAddress.setName(name.toString());
        return mailAddress;
    }

    private void getMailContent(Part message, StringBuffer bodyText, Mail mail) throws Exception {
        String contentType = message.getContentType();
        int nameindex = contentType.indexOf("name");
        boolean conname = false;
        if (nameindex != -1) {
            conname = true;
        }
        if ((message.isMimeType("text/plain") || message.isMimeType("text/html")) && !conname) {
            bodyText.append((String)message.getContent());
        } else if (message.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)message.getContent();
            int count = multipart.getCount();
            LinkedHashMap<String, BodyPart> partMap = new LinkedHashMap<String, BodyPart>();
            boolean blnTxt = false;
            boolean blnHtml = false;
            for (int i = 0; i < count; ++i) {
                BodyPart tmpPart = multipart.getBodyPart(i);
                String partType = tmpPart.getContentType();
                if (tmpPart.isMimeType("text/plain")) {
                    partMap.put("text/plain", tmpPart);
                    blnTxt = true;
                    continue;
                }
                if (tmpPart.isMimeType("text/html")) {
                    partMap.put("text/html", tmpPart);
                    blnHtml = true;
                    continue;
                }
                partMap.put(partType, tmpPart);
            }
            if (blnTxt && blnHtml) {
                partMap.remove("text/plain");
            }
            Set set = partMap.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                this.getMailContent((Part)it.next().getValue(), bodyText, mail);
            }
        } else if (message.isMimeType("message/rfc822")) {
            this.getMailContent((Part)message.getContent(), bodyText, mail);
        } else if (message.isMimeType("application/octet-stream") || message.isMimeType("image/*") || message.isMimeType("application/*")) {
            if (this.mailSetting.getIsHandleAttach().booleanValue()) {
                this.handler.handle(message, mail);
            } else {
                String filename = MimeUtility.decodeText((String)message.getFileName());
                mail.getMailAttachments().add(new MailAttachment(filename, ""));
            }
        }
    }

    private Properties getProperty(String protocal, MailSetting mailSet) {
        if (BeanUtils.isEmpty((Object)((Object)mailSet))) {
            if (BeanUtils.isEmpty((Object)((Object)this.mailSetting))) {
                throw new SystemException("mailSetting\u4e3a\u7a7a\uff0cMailUtil\u5728\u521d\u59cb\u5316\u65f6\u5931\u8d25.");
            }
            mailSet = this.mailSetting;
        }
        Security.addProvider((java.security.Provider)new Provider());
        Properties props = new Properties();
        if (mailSet.getSSL().booleanValue()) {
            props.setProperty("mail." + protocal + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        props.setProperty("mail." + protocal + ".socketFactory.fallback", "false");
        if ("smtp".equals(protocal)) {
            String host = mailSet.getSendHost();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.port", mailSet.getSendPort());
            props.setProperty("mail.smtp.socketFactory.port", mailSet.getSendPort());
            props.setProperty("mail.smtp.auth", String.valueOf(mailSet.getValidate()));
            int gmail = host.indexOf("gmail");
            int live = host.indexOf("live");
            if (gmail != -1 || live != -1) {
                props.setProperty("mail.smtp.starttls.enable", "true");
            }
            if (!mailSet.getSSL().booleanValue()) {
                props.setProperty("mail.smtp.socketFactory.class", "javax.net.SocketFactory");
            }
        } else {
            props.setProperty("mail." + protocal + ".host", mailSet.getReceiveHost());
            props.setProperty("mail." + protocal + ".port", mailSet.getReceivePort());
            props.setProperty("mail." + protocal + ".socketFactory.port", mailSet.getReceivePort());
            if ("pop3".equals(protocal)) {
                props.setProperty("mail.smtp.starttls.enable", "true");
            } else {
                props.setProperty("mail.store.protocol", "imap");
            }
        }
        return props;
    }

    private Session getMailSession(String protocal) {
        Properties props = this.getProperty(protocal, null);
        props.setProperty("mail.smtp.ssl.trust", "*");
        Session mailSession = null;
        mailSession = "imap".equals(protocal) ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailUtil.this.mailSetting.getMailAddress(), MailUtil.this.mailSetting.getPassword());
            }
        }) : Session.getInstance((Properties)props, null);
        return mailSession;
    }

    private Session getMailSession(String protocal, final MailSetting mailSet) {
        Properties props = this.getProperty(protocal, mailSet);
        props.setProperty("mail.smtp.ssl.trust", "*");
        Session mailSession = null;
        mailSession = "imap".equals(protocal) ? Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                try {
                    return new PasswordAuthentication(mailSet.getMailAddress(), mailSet.getPassword());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }) : Session.getInstance((Properties)props, null);
        return mailSession;
    }

    private void addAddressInfo(Mail mail, Message message, MailSetting mailSet) throws UnsupportedEncodingException, MessagingException {
        if (BeanUtils.isEmpty((Object)((Object)mailSet))) {
            mailSet = this.mailSetting;
        }
        InternetAddress senderAddress = this.toInternetAddress(mailSet.getNickName(), mailSet.getMailAddress());
        message.setFrom((Address)senderAddress);
        this.addAddressInfo(message, mail.getReceiverAddresses(), Message.RecipientType.TO);
        this.addAddressInfo(message, mail.getCopyToAddresses(), Message.RecipientType.CC);
        this.addAddressInfo(message, mail.getBcCAddresses(), Message.RecipientType.BCC);
    }

    private void addEmailAddressInfo(MailLing mail, Message message, MailSetting mailSet) throws UnsupportedEncodingException, MessagingException {
        if (BeanUtils.isEmpty((Object)((Object)mailSet))) {
            mailSet = this.mailSetting;
        }
        InternetAddress senderAddress = this.toInternetAddress(mailSet.getNickName(), mailSet.getMailAddress());
        message.setFrom((Address)senderAddress);
        this.addAddressInfo(message, mail.getTo(), Message.RecipientType.TO);
        this.addAddressInfo(message, mail.getCc(), Message.RecipientType.CC);
        this.addAddressInfo(message, mail.getBcc(), Message.RecipientType.BCC);
    }

    private void addAddressInfo(Message message, String address, Message.RecipientType recipientType) throws UnsupportedEncodingException, MessagingException {
        Object[] addressArr;
        MailAddress mailAddress = new MailAddress();
        ArrayList<MailAddress> addressList = new ArrayList<MailAddress>();
        if (address != null && !"".equals(address)) {
            for (InternetAddress id : addressArr = address.split(",")) {
                mailAddress = new MailAddress();
                mailAddress.setAddress((String)id);
                mailAddress.setName((String)id);
                addressList.add(mailAddress);
            }
        }
        if (BeanUtils.isEmpty(addressList)) {
            return;
        }
        addressArr = this.toInternetAddress(addressList);
        if (BeanUtils.isNotEmpty((Object)addressArr)) {
            message.addRecipients(recipientType, (Address[])addressArr);
        }
    }

    private InternetAddress toInternetAddress(String name, String address) throws UnsupportedEncodingException, AddressException {
        if (name != null && !name.trim().equals("")) {
            return new InternetAddress(address, MimeUtility.encodeWord((String)name, (String)CHARSET, (String)"Q"));
        }
        return new InternetAddress(address);
    }

    private InternetAddress toInternetAddress(MailAddress emailAddress) throws UnsupportedEncodingException, AddressException {
        return this.toInternetAddress(emailAddress.getName(), emailAddress.getAddress());
    }

    private InternetAddress[] toInternetAddress(List<MailAddress> list) throws UnsupportedEncodingException, AddressException {
        if (list == null) {
            return null;
        }
        InternetAddress[] address = new InternetAddress[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            address[i] = this.toInternetAddress(list.get(i));
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Folder folder, Store store) {
        try {
            if (folder != null && folder.isOpen()) {
                folder.close(this.mailSetting.getIsDeleteRemote().booleanValue());
            }
            if (store != null && store.isConnected()) {
                store.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            folder = null;
            store = null;
        }
    }
}

