/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.feign.impl;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackFeignServiceHandler
implements InvocationHandler {
    private Logger logger = LoggerFactory.getLogger(FallbackFeignServiceHandler.class);
    protected String feignServiceName;
    protected Throwable fallbackError;

    public FallbackFeignServiceHandler(String feignServiceName, Throwable cause) {
        this.feignServiceName = feignServiceName;
        this.fallbackError = cause;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.logger.error("Feign\u3010" + this.feignServiceName + "\u3011invoke method \u3010" + method.getName() + "\u3011 failed.", this.fallbackError);
        this.logger.debug("\u63a5\u53e3\u53c2\u6570\u4fe1\u606f\uff1a" + JsonUtil.toJsonString(args));
        Class<CommonResult> retType = method.getReturnType();
        if (retType.isAssignableFrom(CommonResult.class)) {
            String message = "\u670d\u52a1\u3010" + this.feignServiceName + "\u3011\u7e41\u5fd9\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01";
            return new CommonResult<String>(ResponseErrorEnums.SERVICE_INVOKE_ERROR, message);
        }
        throw new BaseException(ResponseErrorEnums.SERVICE_INVOKE_ERROR, "\u3010" + this.feignServiceName + "." + method.getName() + "\u3011\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01");
    }
}

