/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.params.MessageAndConfigVo;
import com.artfess.application.service.TemplateService;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.jms.Notice;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jms/v1"})
@Api(tags={"\u961f\u5217\u6d88\u606f\u53d1\u9001"})
@ApiGroup(group={"group_application"})
public class JmsProducerController {
    @Resource
    TemplateService templateService;

    @RequestMapping(value={"sendNoticeToQueue"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f", httpMethod="POST", notes="\u53d1\u9001\u6d88\u606f")
    public CommonResult<String> sendNoticeToQueue(@ApiParam(name="notice", value="\u901a\u77e5(\u901a\u8fc7\u6a21\u677f\u6765\u53d1\u9001\u7684\u6d88\u606f)") @RequestBody Notice notice) throws Exception {
        this.templateService.sendNotice2Jms(notice);
        return new CommonResult(true, "\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"sendToQueue"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d", httpMethod="POST", notes="\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\u4e2d")
    public CommonResult<String> sendToQueue(@ApiParam(name="notice", value="\u901a\u77e5(\u901a\u8fc7\u6a21\u677f\u6765\u53d1\u9001\u7684\u6d88\u606f)") @RequestBody ObjectNode model) throws Exception {
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)model);
        return new CommonResult(true, "\u6210\u529f\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\uff01");
    }

    @RequestMapping(value={"sendToQueueByMessageConfig"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u6d88\u606f\u914d\u7f6e\u53d1\u9001\u6d88\u606f", httpMethod="POST", notes="\u901a\u8fc7\u6d88\u606f\u914d\u7f6e\u53d1\u9001\u6d88\u606f")
    public CommonResult<String> sendToQueueByMessageConfig(@ApiParam(name="messageAndConfigVo", value="\u6d88\u606f\u914d\u7f6e\u53d1\u9001\u6d88\u606fVO") @RequestBody MessageAndConfigVo messageAndConfigVo) throws Exception {
        if (null != messageAndConfigVo) {
            this.templateService.sendToQueueByMessageConfig(messageAndConfigVo.getNotice(), messageAndConfigVo.getMessageConfig());
        }
        return new CommonResult(true, "\u6210\u529f\u53d1\u9001\u6d88\u606f\u5230\u961f\u5217\uff01");
    }
}

