package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 按标签分类查询条件表（BIZ_QUERY_TAG_CONDITION）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizQueryTagCondition对象", description="按标签分类查询条件表（BIZ_QUERY_TAG_CONDITION）")
public class BizQueryTagCondition extends BaseModel<BizQueryTagCondition> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "搜索标签ID【外键】（查企业、查老板、查风险）")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "查询条件目录")
    @TableField("QUERY_CATALOGS_")
    private String queryCatalogs;

    @ApiModelProperty(value = "查询条件字段值类别（1:普通字段 2:枚举字典 3:多维字典项）")
    @TableField("FIELD_VALUE_TYPE_")
    private Integer fieldValueType;

    @ApiModelProperty(value = "字段ID")
    @TableField("FIELD_ID_")
    private String fieldId;

    @ApiModelProperty(value = "字段名称")
    @TableField("FIELD_NAME_")
    private String fieldName;

    @ApiModelProperty(value = "字段英文名（格式：F_字段编码）")
    @TableField("FIELD_CODE_")
    private String fieldCode;

    @ApiModelProperty(value = "字段类型")
    @TableField("FIELD_TYPE_")
    private String fieldType;

    @ApiModelProperty(value = "枚举和多维_CODE（参考枚举和多维定义的CODE值）")
    @TableField("DIMENSION_ID_")
    private String dimensionId;

    @ApiModelProperty(value = "UI组件类型_标识符（text,select,combox,radio,textarea,date,figure,file）")
    @TableField("UI_COM_CODE_")
    private String uiComCode;

    @ApiModelProperty(value = "枚举和多维字典JSON串值（预处理写入）")
    @TableField("DIMENSION_JSON_")
    private String dimensionJson;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "是否支持多选(0：否，1：是)")
    @TableField("IS_MULTI_")
    private Integer isMulti;

    @ApiModelProperty(value = "搜索分类【字典】（1个人 2企业）")
    @TableField(exist = false)
    private String type;

    @ApiModelProperty(value = "搜索标签CODE")
    @TableField(exist = false)
    private String searchCode;

    @ApiModelProperty(value = "搜索标签【字典】（查企业、查老板、查风险）")
    @TableField(exist = false)
    private String searchName;


    @ApiModelProperty(value = "数据库表ID")
    @TableField(exist = false)
    private String tableId;

    @ApiModelProperty(value = "数据源编码")
    @TableField(exist = false)
    private String datasourcesAlias;

    @ApiModelProperty(value = "数据库表名称")
    @TableField(exist = false)
    private String tableCode;

    @ApiModelProperty(value = "数据库表描述")
    @TableField(exist = false)
    private String tableDesc;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getQueryCatalogs() {
        return queryCatalogs;
    }

    public void setQueryCatalogs(String queryCatalogs) {
        this.queryCatalogs = queryCatalogs;
    }

    public Integer getFieldValueType() {
        return fieldValueType;
    }

    public void setFieldValueType(Integer fieldValueType) {
        this.fieldValueType = fieldValueType;
    }

    public String getFieldId() {
        return fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldCode() {
        return fieldCode;
    }

    public void setFieldCode(String fieldCode) {
        this.fieldCode = fieldCode;
    }

    public String getFieldType() {
        return fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getDimensionId() {
        return dimensionId;
    }

    public void setDimensionId(String dimensionId) {
        this.dimensionId = dimensionId;
    }

    public String getUiComCode() {
        return uiComCode;
    }

    public void setUiComCode(String uiComCode) {
        this.uiComCode = uiComCode;
    }

    public String getDimensionJson() {
        return dimensionJson;
    }

    public void setDimensionJson(String dimensionJson) {
        this.dimensionJson = dimensionJson;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public Integer getIsMulti() {
        return isMulti;
    }

    public void setIsMulti(Integer isMulti) {
        this.isMulti = isMulti;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSearchCode() {
        return searchCode;
    }

    public void setSearchCode(String searchCode) {
        this.searchCode = searchCode;
    }

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getDatasourcesAlias() {
        return datasourcesAlias;
    }

    public void setDatasourcesAlias(String datasourcesAlias) {
        this.datasourcesAlias = datasourcesAlias;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getTableDesc() {
        return tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Override
    public String toString() {
        return "BizQueryTagCondition{" +
            "id=" + id +
            ", tagId=" + tagId +
            ", fieldValueType=" + fieldValueType +
            ", fieldId=" + fieldId +
            ", fieldName=" + fieldName +
            ", fieldCode=" + fieldCode +
            ", fieldType=" + fieldType +
            ", dimensionId=" + dimensionId +
            ", uiComCode=" + uiComCode +
            ", dimensionJson=" + dimensionJson +
            ", sn=" + sn +
        "}";
    }
}
