/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.query.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.query.dao.BizQueryResultConditionDao;
import com.artfess.query.manager.BizQueryMyFollowManager;
import com.artfess.query.manager.BizQueryResultConditionManager;
import com.artfess.query.manager.BizQueryResultMainManager;
import com.artfess.query.manager.BizQueryTagHistoryManager;
import com.artfess.query.manager.BizQueryTagManager;
import com.artfess.query.model.BizQueryMyFollow;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.model.BizQueryTag;
import com.artfess.query.model.BizQueryTagHistory;
import com.artfess.query.vo.ParamVo;
import com.artfess.query.vo.QueryParamVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizQueryResultConditionManagerImpl
extends BaseManagerImpl<BizQueryResultConditionDao, BizQueryResultCondition>
implements BizQueryResultConditionManager {
    private static final Logger log = LoggerFactory.getLogger(BizQueryResultConditionManagerImpl.class);
    @Resource
    JdbcTemplate template;
    @Resource
    BizQueryTagManager tagManager;
    @Resource
    BizQueryResultMainManager resultMainManager;
    @Resource
    BizQueryTagHistoryManager tagHistoryManager;
    @Resource
    BizQueryMyFollowManager myFollowManager;

    @Override
    public Map<String, Object> queryDataList(QueryParamVo queryParamVo) throws Exception {
        HttpServletRequest request;
        BizQueryTagHistory tagHistory;
        BizQueryTag tag = (BizQueryTag)((Object)this.tagManager.getById((Serializable)((Object)queryParamVo.getTagId())));
        if (null == tag) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5bfc\u5bf9\u5e94\u6807\u7b7e\u3002");
        }
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)tag.getDatasourcesAlias());
        String mainTable = queryParamVo.getTableName();
        StringBuffer queryWhere = new StringBuffer("where ");
        StringBuffer sql = new StringBuffer("select t.* from ");
        sql.append(mainTable).append(" t ");
        List<ParamVo> queryParamVos = queryParamVo.getParamVoList();
        String searchContent = "";
        for (int i = 0; i < queryParamVos.size(); ++i) {
            ParamVo paramVo = queryParamVos.get(i);
            String field = paramVo.getField();
            String value = paramVo.getValue();
            if (field.equals(tag.getSearchFieldCode())) {
                searchContent = value;
            }
            String con = paramVo.getCon();
            if (value.indexOf(",") == -1) {
                if ("eq".equals(con)) {
                    if (queryWhere.toString().equals("where ")) {
                        queryWhere.append(field).append(" = '").append(value).append("'");
                        continue;
                    }
                    queryWhere.append(" and ").append(field).append(" = '").append(value).append("'");
                    continue;
                }
                if ("seem".equals(con)) {
                    if (queryWhere.toString().equals("where ")) {
                        queryWhere.append(field).append(" like '%").append(value).append("%'");
                        continue;
                    }
                    queryWhere.append(" and ").append(field).append(" like '%").append(value).append("%'");
                    continue;
                }
                if (queryWhere.toString().equals("where ")) {
                    queryWhere.append(field).append(" = '").append(value).append("'");
                    continue;
                }
                queryWhere.append(" and ").append(field).append(" = '").append(value).append("'");
                continue;
            }
            if ("scope".equals(con)) {
                String[] v = value.split(",");
                if (queryWhere.toString().equals("where ")) {
                    queryWhere.append(field).append(" > ").append(v[0]).append(" and ").append(field).append(" < ").append(v[1]);
                    continue;
                }
                queryWhere.append(" and ").append(field).append(" > ").append(v[0]).append(" and ").append(field).append(" < ").append(v[1]);
                continue;
            }
            if (!"in".equals(con)) continue;
            if (queryWhere.toString().equals("where ")) {
                queryWhere.append(field).append(" in ('").append(value.replace(",", "','")).append("')");
                continue;
            }
            queryWhere.append(" and ").append(field).append(" in ('").append(value.replace(",", "','")).append("')");
        }
        if (!"where ".equals(queryWhere.toString())) {
            sql.append(" ").append(queryWhere);
        }
        sql.append(" limit ").append((queryParamVo.getPageNo() - 1) * queryParamVo.getPageSize()).append(" , ").append(queryParamVo.getPageSize());
        log.info(sql.toString());
        IUser user = ContextUtil.getCurrentUser();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SEARCH_CONTENT_", (Object)searchContent);
        queryWrapper.eq((Object)"USER_ID_", (Object)user.getUserId());
        queryWrapper.eq((Object)"date(SEARCH_TIME_)", (Object)DateUtils.nowDate());
        queryWrapper.orderByDesc((Object)"SEARCH_TIME_");
        List tagHistoryList = this.tagHistoryManager.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)tagHistoryList) && StringUtil.isNotEmpty((String)searchContent)) {
            tagHistory = new BizQueryTagHistory();
            tagHistory.setType(tag.getType());
            tagHistory.setUserId(user.getUserId());
            tagHistory.setTagId(tag.getId());
            tagHistory.setUserCard(user.getAccount());
            tagHistory.setUserName(user.getUsername());
            tagHistory.setUserPhone(user.getMobile());
            tagHistory.setSearchContent(searchContent);
            tagHistory.setSearchTime(LocalDateTime.now());
            request = HttpUtil.getRequest();
            tagHistory.setIpAddress(BizQueryResultConditionManagerImpl.getIpAddress(request));
            this.tagHistoryManager.create((Model)tagHistory);
        } else if (!CollectionUtils.isEmpty((Collection)tagHistoryList)) {
            tagHistory = (BizQueryTagHistory)((Object)tagHistoryList.get(0));
            tagHistory.setSearchTime(LocalDateTime.now());
            request = HttpUtil.getRequest();
            tagHistory.setIpAddress(BizQueryResultConditionManagerImpl.getIpAddress(request));
            this.tagHistoryManager.updateById((Object)tagHistory);
        }
        Integer count = 0;
        List resultList = jdbcTemplate.queryForList(sql.toString());
        if (!CollectionUtils.isEmpty((Collection)resultList)) {
            String countSQl = "select count(*) from " + mainTable + " " + queryWhere;
            count = (Integer)jdbcTemplate.queryForObject(countSQl, Integer.class);
            QueryWrapper followWrapper = new QueryWrapper();
            followWrapper.eq((Object)"USER_ID_", (Object)user.getUserId());
            followWrapper.eq((Object)"TAG_ID_", (Object)tag.getId());
            List followList = this.myFollowManager.list((Wrapper)followWrapper);
            if (!CollectionUtils.isEmpty((Collection)followList)) {
                block1: for (Map map : resultList) {
                    map.put("focus", 0);
                    for (BizQueryMyFollow follow : followList) {
                        if (!follow.getSearchContent().equals(map.get(tag.getSearchFieldCode()))) continue;
                        map.put("focus", 1);
                        map.put("followId", follow.getId());
                        continue block1;
                    }
                }
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("total", count);
        resultMap.put("data", resultList);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> queryDataById(String tagId, String tableName, String fieldName, String fieldValue) throws Exception {
        BizQueryTag tag = (BizQueryTag)((Object)this.tagManager.getById((Serializable)((Object)tagId)));
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)tag.getDatasourcesAlias());
        StringBuffer sql = new StringBuffer("select * from ");
        sql.append(tableName).append(" where ").append(fieldName).append(" = ").append("'").append(fieldValue).append("'");
        return jdbcTemplate.queryForList(sql.toString());
    }

    @Override
    public List<Map<String, Object>> queryGroupDataByTag(String tagId, String groupName, String fieldName, String fieldValue) throws Exception {
        Assert.hasText((String)tagId, (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)groupName, (String)"\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fieldName, (String)"\u5173\u8054\u5b57\u6bb5\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fieldValue, (String)"\u5173\u8054\u5b57\u6bb5\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TAG_ID_", (Object)tagId);
        queryWrapper.eq((Object)"GROUP_NAME_", (Object)groupName);
        queryWrapper.ne((Object)"SHOW_TYPE_", (Object)3);
        queryWrapper.orderByAsc((Object)"SN_");
        List resultMains = this.resultMainManager.list((Wrapper)queryWrapper);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (BizQueryResultMain item : resultMains) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            String tableCode = item.getTableCode();
            String tableDesc = item.getTableDesc();
            StringBuffer sql = new StringBuffer();
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)item.getDatasourcesAlias());
            sql.append(" select * from ").append(tableCode).append(" where ").append(fieldName).append(" = ").append("'").append(fieldValue).append("'");
            if (item.getShowType() == 1) {
                sql.append(" limit ").append(0).append(" , ").append(10);
                StringBuffer countSql = new StringBuffer();
                countSql.append(" select count(*) from ").append(tableCode).append(" where ").append(fieldName).append(" = ").append("'").append(fieldValue).append("'");
                Integer count = (Integer)jdbcTemplate.queryForObject(countSql.toString(), Integer.class);
                result.put("total", count);
                result.put("pageNo", 1);
                result.put("pageSize", 10);
            } else {
                sql.append(" limit 1 ");
            }
            List dataList = jdbcTemplate.queryForList(sql.toString());
            result.put("groupName", item.getGroupName());
            result.put("showType", item.getShowType());
            result.put("tableDesc", tableDesc);
            result.put("tableCode", tableCode);
            result.put("dataList", dataList);
            resultList.add(result);
        }
        return resultList;
    }

    @Override
    public Map<String, List<Map<String, Object>>> queryGroupCountByTag(String tagId, String fieldName, String fieldVal) throws Exception {
        Assert.hasText((String)tagId, (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fieldName, (String)"\u5173\u8054\u5b57\u6bb5\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)fieldVal, (String)"\u5173\u8054\u5b57\u6bb5\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TAG_ID_", (Object)tagId);
        queryWrapper.ne((Object)"SHOW_TYPE_", (Object)3);
        queryWrapper.orderByAsc((Object)"SN_");
        List mainList = this.resultMainManager.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)mainList)) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        for (BizQueryResultMain main : mainList) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select '" + main.getGroupName() + "' groupName,'" + main.getTableDesc() + "' tableDesc,'" + main.getTableCode() + "' tableCode,'" + main.getSn() + "' sn, count(*) total ").append(" from ").append(main.getTableCode()).append(" where ").append(fieldName).append(" = '").append(fieldVal).append("'");
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)main.getDatasourcesAlias());
            List list = jdbcTemplate.queryForList(sql.toString());
            resultList.addAll(list);
        }
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        Map<String, List<Map>> grouped = resultList.stream().collect(Collectors.groupingBy(map -> (String)map.get("groupName")));
        Map sortedWithinGroup = grouped.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().sorted(Comparator.comparing(map -> (String)map.get("sn"))).collect(Collectors.toList()), (e1, e2) -> e1, LinkedHashMap::new));
        Map groupedAndSorted = sortedWithinGroup.entrySet().stream().sorted(Comparator.comparing(entry -> (String)((Map)((List)entry.getValue()).get(0)).get("sn"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return groupedAndSorted;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            System.err.println(key + "---------" + value);
        }
        return ip;
    }
}

