/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.listener;

import com.artfess.activiti.def.BpmDefUtil;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.impl.event.ProcessInstanceEndEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
@Transactional
public class ProcessInstEndListener
implements ApplicationListener<ProcessInstanceEndEvent>,
Ordered {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={ProcessInstanceEndEvent.class})
    public void onApplicationEvent(ProcessInstanceEndEvent ev) {
        BpmDelegateExecution execution = (BpmDelegateExecution)ev.getSource();
        this.updProcessInstance(execution);
        Integer instCount = (Integer)execution.getSupperVariable("nrOfInstances");
        Integer completeInstCount = (Integer)execution.getSupperVariable("nrOfCompletedInstances");
        if (StringUtil.isNotZeroEmpty((String)execution.getSupperExecutionId()) && (instCount == null || instCount.equals(completeInstCount))) {
            String destination;
            Map commuVars_ = execution.getVariables();
            Map commuVars = ContextThreadUtil.getCommuVars();
            commuVars_.putAll(commuVars);
            ContextThreadUtil.setCommuVars((Map)commuVars_);
            String parentProcInstId = (String)commuVars_.get("parentInstanceId_");
            BpmDelegateExecution supperExecution = execution.getSupperExecution();
            if (BeanUtils.isNotEmpty((Object)supperExecution) && StringUtil.isNotEmpty((String)(destination = this.getDestination(parentProcInstId, supperExecution.getNodeId(), ContextThreadUtil.getActionCmd())))) {
                BpmDefUtil.prepare(supperExecution.getBpmnDefId(), supperExecution.getNodeId(), new String[]{destination});
            }
            this.converCmd(parentProcInstId);
        }
    }

    private void converCmd(String parentProcInstId) {
        BaseActionCmd baseCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        BpmProcessInstance parentProcessInst = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)parentProcInstId));
        DefaultProcessInstCmd cmd = new DefaultProcessInstCmd();
        cmd.setInstId(parentProcInstId);
        cmd.setActionName(baseCmd.getActionName());
        cmd.setBpmIdentities(baseCmd.getBpmIdentities());
        cmd.addTransitVars("processInstance", (Object)parentProcessInst);
        cmd.addTransitVars("bpmTask_", baseCmd.getTransitVars("bpmTask_"));
        cmd.addTransitVars("previous_cmd", (Object)baseCmd);
        ContextThreadUtil.setActionCmd((ActionCmd)cmd);
    }

    private void updProcessInstance(BpmDelegateExecution execution) {
        String instId = (String)execution.getVariable("instanceId_");
        BaseActionCmd cmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        String procInstId = instance.getId();
        DefaultBpmCheckOpinion entity = BpmCheckOpinionUtil.buildBpmCheckOpinion((BpmDelegateExecution)execution, (String)instId, (Boolean)true);
        DefaultBpmTask task = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        if (BeanUtils.isNotEmpty((Object)task)) {
            entity.setParentTaskId(task.getTaskId());
        }
        this.bpmCheckOpinionManager.create((Model)entity);
        this.bpmCheckOpinionManager.archiveHistory(procInstId);
        this.updateStatus(instance, cmd.getActionName());
        ArrayList<String> instList = new ArrayList<String>();
        instList.add(procInstId);
        this.bpmSignDataManager.delByInstList(instList);
        this.bpmCustomSignDataManager.removeByInstId(procInstId);
    }

    private void updateStatus(DefaultBpmProcessInstance instance, String actionName) {
        instance.setStatus(ProcessInstanceStatus.STATUS_END.getKey());
        instance.setDuration(this.getDuration(instance.getCreateTime()));
        instance.setResultType(actionName);
        instance.setEndTime(LocalDateTime.now());
        this.bpmProcessInstanceManager.update((Model)instance);
    }

    private Long getDuration(LocalDateTime localDateTime) {
        Long duration = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)localDateTime);
        return duration;
    }

    public int getOrder() {
        return 1;
    }

    private String getDestination(String instId, String nodeId, Object transitVars) {
        BpmExeStackManager bpmExeStackManager = (BpmExeStackManager)AppUtil.getBean(BpmExeStackManager.class);
        BpmExeStack stack = bpmExeStackManager.getStack(instId, nodeId, null);
        if (BeanUtils.isNotEmpty((Object)stack) && StringUtil.isNotEmpty((String)stack.getTargetNode())) {
            DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)transitVars;
            cmd.setDestination(stack.getTargetNode());
            return stack.getTargetNode();
        }
        return "";
    }
}

