/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.constants.TenantConstant;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.ServerRejectException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.dao.SysMenuDao;
import com.artfess.sysConfig.persistence.dao.SysMethodDao;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysMethod;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysMenuManager")
public class SysMenuManagerImpl
extends BaseManagerImpl<SysMenuDao, SysMenu>
implements SysMenuManager {
    @Resource
    SysMethodDao sysMethodDao;
    @Resource
    UCFeignService uCFeignService;
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Autowired
    SaaSConfig saaSConfig;
    @Resource
    MultiTenantHandler multiTenantHandler;
    @Resource
    BaseContext baseContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SysMenu getByAlias(String alias) {
        SysMenu sysMenu2 = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            List<SysMethod> sysMethods;
            sysMenu2 = ((SysMenuDao)this.baseMapper).getByAlias(alias);
            if (BeanUtils.isNotEmpty((Object)((Object)sysMenu2)) && BeanUtils.isNotEmpty(sysMethods = this.sysMethodDao.getByMenuAlias(sysMenu2.getAlias()))) {
                sysMenu2.setSysMethods(sysMethods);
            }
            SysMenu sysMenu = sysMenu2;
            return sysMenu;
        }
        catch (Exception el) {
            el.printStackTrace();
            return sysMenu2;
        }
    }

    public SysMenu get(Serializable entityId) {
        List<SysMethod> sysMethods;
        SysMenu sysMenu = (SysMenu)super.get(entityId);
        if (BeanUtils.isNotEmpty((Object)((Object)sysMenu)) && BeanUtils.isNotEmpty(sysMethods = this.sysMethodDao.getByMenuAlias(sysMenu.getAlias()))) {
            sysMenu.setSysMethods(sysMethods);
        }
        return sysMenu;
    }

    public void create(SysMenu entity) {
        super.create((Model)entity);
        this.sysMethodDao.removeByMenuId((Serializable)((Object)entity.getId()));
        List<SysMethod> sysMethods = entity.getSysMethods();
        if (BeanUtils.isNotEmpty(sysMethods)) {
            for (SysMethod sysMethod : sysMethods) {
                sysMethod.setMenuAlias(entity.getAlias());
                sysMethod.setPath(entity.getPath());
                sysMethod.setId(UniqueIdUtil.getSuid());
                this.sysMethodDao.insert((Object)sysMethod);
            }
        }
        this.removeUserMenuCache();
    }

    public void update(SysMenu entity) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        super.update((Model)entity);
        this.sysMethodDao.removeByMenuId((Serializable)((Object)entity.getId()));
        List<SysMethod> sysMethods = entity.getSysMethods();
        if (BeanUtils.isNotEmpty(sysMethods)) {
            for (SysMethod sysMethod : sysMethods) {
                sysMethod.setMenuAlias(entity.getAlias());
                sysMethod.setPath(entity.getPath());
                sysMethod.setId(UniqueIdUtil.getSuid());
                this.sysMethodDao.insert((Object)sysMethod);
            }
        }
        this.removeUserMenuCache();
    }

    public void remove(Serializable entityId) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        this.sysMethodDao.removeByMenuId(entityId);
        super.remove(entityId);
    }

    @Override
    public boolean isExistByAlias(String alias) {
        boolean isInPlateform = false;
        if (this.saaSConfig.isEnable() && !"-1".equals(this.baseContext.getCurrentTenantId())) {
            ArrayList<String> tenantIds = new ArrayList<String>();
            tenantIds.add(this.baseContext.getCurrentTenantId());
            tenantIds.add("-1");
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                isInPlateform = ((SysMenuDao)this.baseMapper).isExistPlateformByAlias(alias, tenantIds) > 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ((SysMenuDao)this.baseMapper).isExistByAlias(alias) > 0 || isInPlateform;
    }

    @Override
    @Transactional
    public void removeByResId(String resId) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        List<SysMenu> list = this.getRecursionById(resId);
        for (SysMenu resource : list) {
            this.remove((Serializable)((Object)resource.getId()));
        }
        this.removeUserMenuCache();
    }

    private List<SysMenu> getRecursionById(String resId) {
        ArrayList<SysMenu> list = new ArrayList<SysMenu>();
        SysMenu resource = this.get((Serializable)((Object)resId));
        list.add(resource);
        List<SysMenu> tmpList = ((SysMenuDao)this.baseMapper).getByParentId(resId);
        if (BeanUtils.isEmpty(tmpList)) {
            return list;
        }
        for (SysMenu sysMenu : tmpList) {
            this.recursion(sysMenu, list);
        }
        return list;
    }

    private void recursion(SysMenu sysMenu, List<SysMenu> list) {
        list.add(sysMenu);
        List<SysMenu> tmpList = ((SysMenuDao)this.baseMapper).getByParentId(sysMenu.getId());
        if (BeanUtils.isEmpty(tmpList)) {
            return;
        }
        for (SysMenu resource : tmpList) {
            this.recursion(resource, list);
        }
    }

    @Cacheable(value={"bpm:sys:userMenu:new"}, key="#currentUser.userId")
    protected String getMenuByUserId(IUser currentUser) throws IOException {
        List<SysMenu> dbMenus = null;
        if (currentUser.isAdmin()) {
            dbMenus = this.getAllByTenant(null, "1");
        }
        if (BeanUtils.isEmpty(dbMenus)) {
            List roles = this.uCFeignService.getRoleListByAccount(currentUser.getAccount());
            ArrayList<String> roleCodes = new ArrayList<String>();
            if (BeanUtils.isNotEmpty((Object)roles)) {
                for (ObjectNode role : roles) {
                    if (1 != role.get("enabled").asInt()) continue;
                    roleCodes.add(role.get("code").asText());
                }
                if (BeanUtils.isNotEmpty(roleCodes)) {
                    String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        List ignoreMenus = null;
                        if (this.saaSConfig.isEnable() && !"-1".equals(currentUser.getTenantId())) {
                            ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentUser.getTenantId());
                        }
                        dbMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCodes, tenantId, BeanUtils.isEmpty(ignoreMenus) ? null : ignoreMenus);
                    }
                    catch (Exception e) {
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        if (BeanUtils.isEmpty(dbMenus)) {
            dbMenus = new ArrayList<SysMenu>();
        }
        this.unique(dbMenus);
        String json = JsonUtil.toJson(dbMenus);
        return json;
    }

    @Override
    public List<SysMenu> getCurrentUserMenu() throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        SysMenuManagerImpl bean = (SysMenuManagerImpl)AppUtil.getBean(this.getClass());
        String menuByUserId = bean.getMenuByUserId(currentUser);
        List<SysMenu> list = new ArrayList<SysMenu>();
        if (menuByUserId != null) {
            list = (List)JsonUtil.toBean((String)menuByUserId, (TypeReference)new TypeReference<List<SysMenu>>(){});
        }
        return list;
    }

    @Override
    public List<SysMenu> getMenuByRole(String roleCodes) {
        IUser currentUser = ContextUtil.getCurrentUser();
        List<SysMenu> dbMenus = new ArrayList<SysMenu>();
        if (BeanUtils.isNotEmpty((Object)roleCodes)) {
            String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                List ignoreMenus = null;
                if (this.saaSConfig.isEnable() && !"-1".equals(currentUser.getTenantId())) {
                    ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentUser.getTenantId());
                }
                List<String> roleCode = Arrays.asList(roleCodes.split(","));
                dbMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCode, tenantId, BeanUtils.isEmpty((Object)ignoreMenus) ? null : ignoreMenus);
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        }
        return dbMenus;
    }

    @Override
    public List<Map<String, Object>> getAllMenuRoleAlias(String roleAlias, String status) {
        QueryWrapper<SysMenu> queryWrapper = this.getTenantQueryWrapper();
        List<Map<String, Object>> result = null;
        String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
        try (MultiTenantIgnoreResult multiTenantIgnoreResult = MultiTenantHandler.setThreadLocalIgnore();){
            queryWrapper.eq(StringUtil.isNotEmpty((String)status), (Object)"STATUS_", (Object)"1");
            result = ((SysMenuDao)this.baseMapper).getAllMenuRoleAlias(roleAlias, tenantId, queryWrapper);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void unique(List<SysMenu> objects) {
        for (int i = 0; i < objects.size() - 1; ++i) {
            for (int j = objects.size() - 1; j > i; --j) {
                if (!objects.get(j).getId().equals(objects.get(i).getId())) continue;
                objects.remove(j);
            }
        }
    }

    @Override
    public List<SysMenu> filterByMenuAlias(String menuAlias, List<SysMenu> lists) {
        ArrayList<SysMenu> result = new ArrayList<SysMenu>();
        if (BeanUtils.isEmpty(lists) || StringUtil.isEmpty((String)menuAlias)) {
            return result;
        }
        String pId = null;
        for (SysMenu sysMenu : lists) {
            if (!menuAlias.equals(sysMenu.getAlias())) continue;
            pId = sysMenu.getId();
            break;
        }
        if (StringUtil.isEmpty(pId)) {
            return result;
        }
        BeanUtils.listByPid(lists, pId, result);
        return BeanUtils.listToTree(result);
    }

    @Override
    public List<SysMenu> getMenuByRoleAlias(String roleAlias) {
        return ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(Arrays.asList(roleAlias.split(",")), null, null);
    }

    @Override
    public List<SysMenu> getAllByTenant(String ignoreAlias, String status) {
        ArrayList<SysMenu> dbMenus = new ArrayList();
        QueryWrapper<SysMenu> queryWrapper = this.getTenantQueryWrapper();
        this.dealWithIgnoreQuery(queryWrapper, ignoreAlias);
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            queryWrapper.eq(StringUtil.isNotEmpty((String)status), (Object)"STATUS_", (Object)"1");
            dbMenus = this.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return dbMenus;
    }

    private void dealWithIgnoreQuery(QueryWrapper<SysMenu> queryWrapper, String ignoreAlias) {
        if (StringUtil.isNotEmpty((String)ignoreAlias)) {
            String[] ignores = ignoreAlias.split(",");
            ArrayList<String> allIgnores = new ArrayList<String>();
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                for (String alias : ignores) {
                    SysMenu menu = ((SysMenuDao)this.baseMapper).getByAlias(alias);
                    if (!BeanUtils.isNotEmpty((Object)((Object)menu))) continue;
                    allIgnores.add(alias);
                    List<SysMenu> childrens = null;
                    childrens = ((SysMenuDao)this.baseMapper).getByChidrensParentPath(menu.getPath());
                    if (!BeanUtils.isNotEmpty(childrens)) continue;
                    for (SysMenu sysMenu : childrens) {
                        allIgnores.add(sysMenu.getAlias());
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            if (BeanUtils.isNotEmpty(allIgnores)) {
                BeanUtils.removeDuplicate(allIgnores);
                allIgnores.addAll(TenantConstant.IGNORE_MENU);
                queryWrapper.and(consumer -> consumer.notIn((Object)"alias_", (Collection)allIgnores));
            }
        }
    }

    private QueryWrapper<SysMenu> getTenantQueryWrapper() {
        IUser currentUser = ContextUtil.getCurrentUser();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (this.saaSConfig.isEnable()) {
            ((QueryWrapper)queryWrapper.or()).in((Object)this.multiTenantHandler.getTenantIdColumn(), Arrays.asList("-1", currentUser.getTenantId()));
            if (!"-1".equals(currentUser.getTenantId())) {
                queryWrapper.and(consumer -> {
                    ArrayList allIgnoreMenus = new ArrayList();
                    allIgnoreMenus.addAll(TenantConstant.IGNORE_MENU);
                    try {
                        List ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentUser.getTenantId());
                        if (BeanUtils.isNotEmpty((Object)ignoreMenus)) {
                            allIgnoreMenus.addAll(ignoreMenus);
                        }
                    }
                    catch (Exception e) {
                        throw new BaseException("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7981\u7528\u83dc\u5355\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    consumer.notIn((Object)"alias_", allIgnoreMenus);
                });
            }
        } else {
            queryWrapper.notIn((Object)"alias_", new Object[]{"tenant", "tenantManager", "tenantTypeManager", "tenantParamsManager"});
        }
        queryWrapper.orderByAsc((Object)"sn_");
        return queryWrapper;
    }

    private void removeUserMenuCache() {
        SysMenuManagerImpl bean = (SysMenuManagerImpl)AppUtil.getBean(this.getClass());
        bean.delUserMenuCache();
    }

    @Override
    @CacheEvict(value={"bpm:sys:userMenu:new"}, allEntries=true)
    public void delUserMenuCache() {
    }

    @Override
    public List<SysMenu> getByChidrensParentPath(String path) {
        return ((SysMenuDao)this.baseMapper).getByChidrensParentPath(path);
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath, String parentMenuId) {
        block22: {
            try {
                SysMenu baseParentMenu = this.get((Serializable)((Object)parentMenuId));
                String parentJson = FileUtil.readFile((String)(unZipFilePath + File.separator + "parentMenu.json"));
                SysMenu psysMenu = (SysMenu)((Object)JsonUtil.toBean((String)parentJson, SysMenu.class));
                String npMenuId = UniqueIdUtil.getSuid();
                String basePath = baseParentMenu.getPath() + npMenuId + ".";
                String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysMenus.json"));
                List list = (List)JsonUtil.toBean((String)json, List.class);
                ArrayList<SysMenu> newMenus = new ArrayList<SysMenu>();
                HashMap<String, String> idsMap = new HashMap<String, String>();
                for (Object o : list) {
                    SysMenu sysMenu = (SysMenu)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysMenu.class));
                    SysMenu menu = this.getByAlias(sysMenu.getAlias());
                    if (BeanUtils.isNotEmpty((Object)((Object)menu))) {
                        throw new BaseException("\u5bfc\u5165\u83dc\u5355\u4e2d\u67d0\u4e9b\u522b\u540d\u5df2\u5b58\u5728\u3002");
                    }
                    if (sysMenu.getId().equals(psysMenu.getId())) {
                        sysMenu.setParentId(parentMenuId);
                        sysMenu.setPath(basePath);
                    } else {
                        String nId = UniqueIdUtil.getSuid();
                        idsMap.put(sysMenu.getId(), nId);
                        String[] cpath = sysMenu.getPath().split("." + psysMenu.getId() + ".");
                        String suffix = cpath[1].replace(sysMenu.getId() + ".", nId + ".");
                        sysMenu.setId(nId);
                        sysMenu.setPath(basePath + suffix);
                    }
                    newMenus.add(sysMenu);
                }
                if (!BeanUtils.isNotEmpty(newMenus)) break block22;
                String tenantId = this.baseContext.getCurrentTenantId();
                try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                    for (SysMenu sysMenu : newMenus) {
                        if (idsMap.containsKey(sysMenu.getParentId())) {
                            sysMenu.setParentId((String)idsMap.get(sysMenu.getParentId()));
                        }
                        sysMenu.setTenantId(tenantId);
                        this.create(sysMenu);
                    }
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage());
            }
        }
    }

    @Override
    public Map<String, List<SysMenu>> getThreeAdminMenu(String tenantId) throws Exception {
        HashMap<String, List<SysMenu>> map = new HashMap<String, List<SysMenu>>();
        List ignoreMenus = null;
        if (this.saaSConfig.isEnable() && !"-1".equals(tenantId)) {
            ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(tenantId);
        }
        ArrayList<String> roleCode = new ArrayList<String>();
        roleCode.add("sysRole");
        List<SysMenu> systemRoleMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCode, tenantId, BeanUtils.isEmpty((Object)ignoreMenus) ? null : ignoreMenus);
        map.put("sysadmin", systemRoleMenus);
        roleCode.clear();
        roleCode.add("secRole");
        List<SysMenu> secRoleMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCode, tenantId, BeanUtils.isEmpty((Object)ignoreMenus) ? null : ignoreMenus);
        map.put("secadmin", secRoleMenus);
        roleCode.clear();
        roleCode.add("auditRole");
        List<SysMenu> auditRoleMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCode, tenantId, BeanUtils.isEmpty((Object)ignoreMenus) ? null : ignoreMenus);
        map.put("audit", auditRoleMenus);
        return map;
    }
}

