import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全工作计划信息
  addCmgtSaftyPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyPlan/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全工作计划信息
  editCmgtSaftyPlan(data, cb) {
    req.put(portal + `/manager/cmgtSaftyPlan/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全工作计划信息
  loadCmgtSaftyPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyPlan/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全工作计划信息
  deleteCmgtSaftyPlan(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyPlan/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyPlan/` + id).then(res => {
      cb(res.data)
    })
  },
}
