import req from '@/request.js'
import qs from 'qs'

const portal = window.context.portal
export default {
  // 分页查询安全隐患档案
  loadCmgtSaftyTrainingPlan(data, cb) {
    return req.post(portal + `/manager/cmgtSaftyDangerUnit/query`, data)
  },
  // 分页查询查看档案
  cmgtSaftyDangerCheckplanPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/query`, data).then(res => {
      cb(res.data)
    })
  },

  // 分页查询档案
  CSaftyDangerAbarbeitung(data, cb) {
    return req.post(portal + `/manager/CSaftyDangerAbarbeitung/list`, data)
  },

  // 隐患记录上半部分的主体信息
  cmgtSaftyDangerCheckrecord(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecord/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 隐患记录下半部分的主体信息
  cmgtSaftyDangerCheckrecordDetail(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckrecordDetail/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询实体
  cmgtSaftyTrainPlanId(data, cb) {
    req.get(portal + `/manager/cmgtSaftyTrainPlan/` + data).then(res => {
      cb(res.data)
    })
  },
  // 考评人
  getAllUser(cb) {
    req.get(portal + `/api/user/v1/users/getAllUser`).then(res => {
      cb(res.data)
    })
  },

  // 参与单位
  cmgtSaftyDangerUnit(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/query`, data).then(res => {
      cb(res.data)
    })
  },

  // 参与单位
  investigatePlan(query) {
    return req.get(portal + `/manager/cmgtSaftyDangerCheckscheme/investigatePlan?${qs.stringify(query)}`)
  }
}
