import req from '@/request.js'
import qs from 'qs'

const portal = window.context.portal
export default {
  // 查询动态选项集合
  loadSelectOptions(data, cb) {
    req.get(portal + `/manager/common/select/options?` + qs.stringify(data, {
      indices: false
    })).then(res => {
      cb(res.data)
    })
  },
  editCmgtSaftyTarget(cb) {
    req.get(portal + `/manager/cmgtDutyGrid/list`).then(res => {
      cb(res.data)
    })
  },
  // 获取勤务月份选项
  loadDutyMonths() {
    return new Promise(resolve => {
      req.get(portal + `/manager/common/select/duty/months`).then(res => resolve(res.data))
    })
  },

  // 获取勤务月度天数选项
  loadDutyDays(day, cb) {
    req.get(portal + `/manager/common/select/duty/days?cdate=` + day).then(res => {
      cb(res.data)
    })
  },

  // 获取综合局组织
  loadZGJOrgs() {
    return new Promise(resolve => {
      req.get(portal + `/manager/common/select/org/zgj`).then(res => resolve(res.data))
    })
  },

  // 获取勤务查询状态
  loadDutyStatusList(cb) {
    req.get(portal + `/manager/common/select/duty/status`).then(res => {
      cb(res.data)
    })
  },


  downloadFile(data) {
    req.downloadGetCopy(portal + '/file/v1/downloadFile?fileId=' + data)
  },

  uploadUrl: window.context.portal + '/file/v1/fileUpload', // 服务器上传地址

  uploadExcel: window.context.portal + '/manager/common/upload/excel', // 服务器上传地址

  getAllOrgTree(cb) { // 获取组织树
    req.get(portal + '/manager/cmgtDutyOrgWorkarrange/findAllOrgTree').then(res => {
      cb(res)
    })
  },
  getNextCode(cb) {
    req.get(portal + '/sys/identity/v1/getNextIdByAlias?alias=lsh').then(res => {
      cb(res.data)
    })
  },
  getNextCodeByAlias(alias, cb) {
    req.get(portal + '/sys/identity/v1/getNextIdByAlias?alias=' + alias).then(res => {
      cb(res.data)
    })
  },
  getArrangeOrgTree(cb) { // 获取组织树
    req.get(portal + '/manager/cmgtDutyOrgWorkarrange/findArrangeOrg').then(res => {
      cb(res)
    })
  }
}
