import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增排班信息
  addWorkclass(data, cb) {
    req.post(portal + `/manager/duty/workclass/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改排班信息
  editWorkclass(data, cb) {
    req.put(portal + `/manager/duty/workclass/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询排班信息
  loadWorkclass(data, cb) {
    req.post(portal + `/manager/duty/workclass/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除排班信息
  deleteWorkclass(data, cb) {
    req.remove(portal + `/manager/duty/workclass/`, data).then(res => {
      cb(res.data)
    })
  },
}