import req from '@/request.js'
import { get } from 'lodash'

const portal = window.context.portal
export default {
  /*危险源设备 实时监测 */
  // 分页查询
  loadQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/data/hazard/query`, data)
        .then(res => resolve(res.data || {}))
        .catch(err => reject(err))
    })
  },

  /*危险源设备 事件信息 */
  // 分页查询
  loadInfo(data, cb) {
    req.post(portal + `/device/warnInfo/query`, data).then(res => {
      cb(res.data)
    })
  },

  /*预警信息! */
  // 分页查询
  videoWarnPage(data, cb) {
    req.post(portal + `/device/warnInfo/videoWarnPage`, data).then(res => {
      cb(res.data)
    })
  },

  /*设备数据查询 */
  getDeviceData(data, code) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/data/queryHis?productCode=${code}`, data)
        .then(res => {
          let data = {}
          if(res.data && res.data.value && res.data.value.data){
            data = res.data.value.data
          }
          resolve(data)
        })
        .catch(err => reject(err))
    })
  },
}
