import req from '@/request.js'
const portal = window.context.portal
export default {
	// 获取分组列表数据
	groupList (data, cb) {
		req.post(portal + '/device/group/info/query', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 添加分组信息
	addGroupData (data, cb) {
		req.post(portal + '/device/group/info/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 修改分组信息
	modifyGroupData (data, cb) {
		req.put(portal + '/device/group/info/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 获取设备列表
	findEquipmentList (data, cb) {
		req.post(portal + '/device/info/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 获取已关联设备
	relatedEquipment (data, cb) {
		req.post(portal + '/device/group/info/getDeviceList', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 关联分组&设备
	ConnectionEquipment (data, cb) {
		req.post(portal + '/device/group/info/bindDevice', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
}