export const scrollFormMixin = {
    data() {
        return {
            activeStep: 1,
            stepDomTop: []
        }
    },
    mounted() {
        let formInfo
        this.$nextTick(() => {
            formInfo = this.$refs.formInfo.$el
            this.stepDomTop = this.stepData.map(item => {
                return document.getElementById(item.domId).offsetTop
            })
            formInfo.addEventListener('scroll', this.getScrollId)
        })
    },
    beforedestroyed() {
        let formInfo = this.$refs.formInfo.$el
        formInfo.removeEventListener("scroll", this.getScrollId);
    },
    methods: {
        // 滚动匹配对应步骤
        getScrollId() {
            this.activeStep = 1
            const sroll_top = this.$refs.formInfo.$el.scrollTop + 1
            this.stepDomTop.forEach((item, index, arr) => {
                if (sroll_top >= item && sroll_top < arr[index + 1]) {
                    this.activeStep = index + 1
                }else if(sroll_top>item){
                    this.activeStep = index + 1
                }
            })
        },
        // 滚动到指定位置
        localtion(domId) {
            //指定dom到页面顶端的距离
            let dom = document.getElementById(domId)
            let domHeight = dom.offsetTop
            this.$nextTick(() => {
                this.$refs.formInfo.$el.scrollTop = domHeight
            })
        },

    }
}