import req from '@/request.js'

export const ExtendParamsMixin = {
  data() {
    return {
      portal: window.context.portal,
      extendParams: [],
      extendRuleNames: {},
      paramsValueList: [],
      extendsValue: {},
      hasExtendValue: false
    }
  },
  mounted() {
  },
  methods: {
    // 获取扩展参数配置
    getExtendParams(type) {
      return new Promise((resolve, reject) => {
        req
          .post(this.portal + `/device/base/paramsConf/findAll`, {
            type
          })
          .then(res => {
            if (res.status == 200) {
              this.extendParams = res.data
              console.log(this.extendParams)
              resolve()
            }
          })
      })
    },
    // 获取扩展参数值
    getExtendParamsData(type, id) {
      return new Promise((resolve, reject) => {
        req
          .post(this.portal + `/device/base/paramsConf/getConfValue`, {
            baseId: id,
            type
          })
          .then(res => {
            if (res.status == 200) {
              // 是否已提交过扩展值
              this.paramsValueList = res.data
              if (this.paramsValueList.length) {
                this.hasExtendValue = true
                this.formatExtendData() // 扩展字段数组转对象
              } else {
                this.hasExtendValue = false
              }
              console.log(this.paramsValueList)
              resolve()
            }
          })
      })
    },
    // 扩展参数合并到固定参数和rules验证中
    handleExtendParamsMixin() {
      // console.log(this.params,'iiiiii');
      // return
      let data = {}
      let rules = {}

      this.extendParams.forEach(item => {
        // 必选项加rules验证
        if (item.isRequired == '1') {
          let message
          if (item.ctlType == 'input' || item.ctlType == 'number') {
            message = '请输入' + item.name
          } else {
            message = '请选择' + item.name
          }
          rules[`$extend${item.id}`] = [{
            message,
            required: true,
            trigger: 'change'
          }]
          this.extendRuleNames[`$extend${item.id}`] = `$extend${item.id}`
        }

        // 各类型控件赋值  有扩展的赋值 没有扩展值赋初始值
        if (item.ctlType == 'input') {
          data[`$extend${item.id}`] = this.hasExtendValue ? this.extendsValue[item.id] : ''
        } else if (item.ctlType == 'select' || item.ctlType == 'radio') {
          if (item.json) {
            let options = JSON.parse(item.json)
            data[`$extend${item.id}`] = this.hasExtendValue ? this.extendsValue[item.id] : options.length && options[0].value
          } else {
            data[`$extend${item.id}`] = ''
          }
        } else if (item.ctlType == 'checkbox') {
          if (item.json) {
            let options = JSON.parse(item.json)
            if (this.hasExtendValue) {
              data[`$extend${item.id}`] = this.extendsValue[item.id] ? this.extendsValue[item.id].split(
                ','
              ) : []
            } else {
              data[`$extend${item.id}`] = options.length ? [options[0].value] : []
            }
          } else {
            data[`$extend${item.id}`] = ''
          }
        } else if (item.ctlType == 'number') {
          data[`$extend${item.id}`] = this.hasExtendValue ? this.extendsValue[item.id] : 0
        } else if (item.ctlType == 'date') {
          data[`$extend${item.id}`] = this.hasExtendValue ? this.extendsValue[item.id] : ''
        }
      })
      //-------------------------
      this.params = Object.assign({}, this.params, data)
      console.log(this.params)
      this.$set(this.params)

      this.rules = Object.assign({}, this.rules, rules)
      console.log(this.rules)
      this.$set(this.rules)
    },
    formatExtendData() {
      this.extendsValue = {}
      this.paramsValueList.forEach(item => {
        this.extendsValue[item.confId] = item.value
      })
    },
    handleExtendParamsSave(data, type) {
      this.extendParams.forEach(item => {
        if (item.ctlType === 'checkbox') {
          data[`$extend${item.id}`] = data[`$extend${item.id}`]?.length ?
            data[`$extend${item.id}`].join(',') :
            ''
        }
      })
      let extendList = []
      for (let key in data) {
        if (key.indexOf('$extend') !== -1) {
          extendList.push({
            confId: key.replace('$extend', ''),
            type,
            value: data[key]
          })
          delete data[key]
        }
      }
      data.paramsValueList = extendList
      return data
    }
  }
}
