import req from '@/request.js'

const portal = window.context.portal

// 获取区域设备分析图标数据
export function areaStatusAnalyze(areaId, fullId) {
  return new Promise((resolve, reject) => {
    const formData = new FormData()
    formData.append('fullId', `/1552911478301003776/1651837759125463040/${fullId}`)
    formData.append('areaId', areaId)
    req.post(portal + `/homepage/v1/areaStatusAnalyze`, formData)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 传感器状态对比数据
export function statisticsSensorProportion(deviceType) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/statisticsSensorProportion?deviceType=${deviceType}`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}


// 报警数据分析统计(危险设备)
export function callThePoliceAnalysisStatistics() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/callThePoliceAnalysisStatistics`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 报警数据分析统计(低洼积水,标识牌)
export function alarmStatisticsAnalysis(deviceType) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/alarmStatisticsAnalysis?deviceType=${deviceType}`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 统计报警率最高事件数据
export function statisticsMaxPoliceEvent() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/statisticsMaxPoliceEvent`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 统计报警率设备排名Top5Top5数据
export function statisticsMaxPoliceDevice() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/statisticsMaxPoliceDevice`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

// 统计报警率最高设备区域排名Top5
export function statisticsMaxPoliceArea(deviceType) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/device/warnInfo/statisticsMaxPoliceArea?deviceType=${deviceType}`)
      .then(response => {
        resolve(response.data)
      })
      .catch(error => {
        reject(error)
      })
  })
}

