import req from '@/request.js'
const portal = window.context.portal
export default {
	// 获取备品件列表
	findSMList (data, cb) {
		req.post(portal + '/device/base/spare/query', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 备品供应商
	findCompanyList (data, cb) {
		req.post(portal + '/device/base/company/findAll', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// id查询备品供应商
	findCompanyDetail (id, cb) {
		req.get(portal + '/device/base/company/' + id).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// id查询单条备件数据
	findSpareDetail (id, cb) {
		req.get(portal + '/device/base/spare/' + id).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 添加备品信息
	AddSpareData (data, cb) {
		req.post(portal + '/device/base/spare/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 修改备件信息
	modifySpareData (data, cb) {
		req.put(portal + '/device/base/spare/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
}
