var test = require('tape');
var points = require('../');

var ptsstr = 'm 340.0802,61.38651 c -40.2898,8.22791 -62.56591,65.81112'
    + ' -49.74004,128.6158 12.82587,62.80467 55.90207,107.07364'
    + ' 96.19186,98.84572 40.2898,-8.22791 62.55966,-65.84175'
    + ' 49.73379,-128.64642 C 423.43994,97.39694 380.36999,53.15859'
    + ' 340.0802,61.38651 z m 12.91104,8.55846 c 22.51488,-4.59795'
    + ' 48.14062,27.6983 57.21553,72.13556 9.0749,44.43726 -1.83609,84.19498'
    + ' -24.35097,88.79294 -22.51489,4.59795 -48.11001,-27.70455'
    + ' -57.18492,-72.14182 -9.0749,-44.43726 1.80548,-84.18872'
    + ' 24.32036,-88.78668 z'
    + ' M 363.38912,100.18734 l 7.78212,25.23786 l 15.68721,-12.87912 L 363.38912,100.18734 z'
    + ' v 25 h 75'
;

test('length', function (t) {
    t.plan(1);
    var pt = points(ptsstr);
    var len = pt.length();
    var ref = 1178.3551025390625;
    t.ok(cmp(len, ref, 0.005), len + ' ~~ ' + ref + ' ±0.5%');
});

function cmp (found, wanted, tolerance) {
    return found <= wanted + wanted * tolerance
        && found >= wanted - wanted * tolerance
    ;
}
