/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.TimerSpec;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.Task;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.AbstractTaskExecutor;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Component
public class TimerTaskExecutorProvider
implements TaskExecutorProvider {
    private final Scheduler scheduler = Schedulers.parallel();

    public String getExecutor() {
        return "timer";
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)((Object)new TimerTaskExecutor(context)));
    }

    public static Flux<ZonedDateTime> getLastExecuteTimes(String cronExpression, Date from, long times) {
        return Flux.defer(() -> Flux.fromIterable((Iterable)TimerSpec.cron((String)cronExpression).getNextExecuteTimes(ZonedDateTime.ofInstant(from.toInstant(), ZoneId.systemDefault()), times)));
    }

    class TimerTaskExecutor
    extends AbstractTaskExecutor {
        Supplier<Duration> nextDelay;
        TimerSpec spec;
        Predicate<LocalDateTime> filter;

        public TimerTaskExecutor(ExecutionContext context) {
            super(context);
            this.nextDelay = this.createNextDelay();
        }

        public String getName() {
            return "\u5b9a\u65f6\u8c03\u5ea6";
        }

        protected Disposable doStart() {
            return this.execute();
        }

        private Disposable execute() {
            Duration nextTime = this.nextDelay.get();
            this.context.getLogger().debug("trigger timed task after {}", new Object[]{nextTime});
            if (this.disposable != null) {
                this.disposable.dispose();
            }
            this.disposable = Mono.delay((Duration)nextTime, (Scheduler)TimerTaskExecutorProvider.this.scheduler).flatMap(t -> {
                if (!this.filter.test(LocalDateTime.now())) {
                    return Mono.empty();
                }
                HashMap<String, Long> data = new HashMap<String, Long>();
                long currentTime = System.currentTimeMillis();
                data.put("timestamp", currentTime);
                data.put("_now", currentTime);
                return this.context.getOutput().write((Publisher)Mono.just((Object)this.context.newRuleData(data))).then(this.context.fireEvent("complete", this.context.newRuleData((Object)System.currentTimeMillis())).thenReturn((Object)1));
            }).onErrorResume(err -> this.context.onError(err, null).then(Mono.empty())).doFinally(s -> {
                if (this.getState() == Task.State.running && s != SignalType.CANCEL) {
                    this.execute();
                }
            }).subscribe();
            return this.disposable;
        }

        public void reload() {
            this.nextDelay = this.createNextDelay();
            this.disposable = this.doStart();
        }

        public void validate() {
            this.createNextDelay();
        }

        private Supplier<Duration> createNextDelay() {
            TimerSpec spec = (TimerSpec)FastBeanCopier.copy((Object)this.context.getJob().getConfiguration(), (Object)new TimerSpec(), (String[])new String[0]);
            Function builder = spec.nextDurationBuilder();
            this.filter = spec.createTimeFilter();
            return () -> (Duration)builder.apply(ZonedDateTime.now());
        }
    }
}

