import option from './option.js'
export const basicPagesMixin = {
  data() {
    return {
      index: 1, //基础数据点击索引
      query: {}, //桥梁类别统计和隧道等级以及各个结构数量统计请求参数
      queryMileage: {
        companyId: '',
        companyName: '',
        roadSegmentId: ''
      }, //里程排行榜
      type: '', //判断基础数据渲染哪一个
      option1: option[1], //路段的数据
      option_2: option[2], //沿线设施数据
      option1_2: option[3], //边坡数据
      option_3: option[3], //边坡数据
      option_4: option[4], //桥梁数据
      option_5: option[5], //桥梁数据
      option_6: option[6], //涵洞数据
      option2: option[7], //桥梁类别统计
      option3: option[8], //隧道等级统计
      option10: option[12], //养护车辆统计
      mapCenter: [107.400147, 29.812421],
      BasicData: [], //基础设施数据
      // BasicUrl: '/baseDataStatistics/v1/getRoad', //初始化基础设施路段接口地址
      BasicUrl:
        '/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/getJson', // '/road/roadmanage/v1/getJson', //初始化基础设施路段接口地址
      BasicType: 1, //判断目前点击的是那一个设施
      pageResult: {
        page: 1,
        pageSize: 20,
        total: 0
      },
      querysMap: {
        pageBean: {
          page: 1,
          pageSize: 1000,
          showTotal: true
        },
        params: {},
        querys: [
          {
            group: 'advance',
            operation: 'LIKE',
            property: 'road_segment_name_',
            relation: 'AND',
            value: '' //永泸高速
          },
          {
            group: 'advance',
            operation: 'LIKE',
            property: 'road_segment_id_',
            relation: 'AND',
            value: ''
          }
        ]
      },
      queryBasic: {
        pageBean: {
          page: 1,
          pageSize: 10,
          showTotal: true
        },
        params: {},
        querys: []
      },
      urlMap: '/bizBridgeInformation/v1/getList', //请求地图桥梁数据，默认值
      basicData_1: [
        // {
        //   id: 1,
        //   index: 1,
        //   count: 45,
        //   name: '路段'
        // },
        {
          id: 1,
          index: 1,
          count: 45,
          name: '服务区'
        },
        {
          id: 2,
          index: 2,
          count: 45,
          name: '收费站'
        },
        {
          id: 3,
          index: 3,
          count: 45,
          hightCount: 45,
          notHigthcount: 45,
          name: '边坡'
        }
      ],
      basicData_2: [
        {
          id: 4,
          index: 4,
          name: '桥梁',
          data: [
            {
              name: '特大',
              count: 455
            },
            {
              name: '大',
              count: 455
            },
            {
              name: '中',
              count: 455
            },
            {
              name: '小',
              count: 455
            }
          ]
        },
        {
          id: 5,
          index: 5,
          name: '隧道',
          data: [
            {
              name: '特长',
              count: 455
            },
            {
              name: '中长',
              count: 455
            },
            {
              name: '长',
              count: 455
            },
            {
              name: '短',
              count: 455
            }
          ]
        },
        {
          id: 6,
          index: 6,
          name: '涵洞',
          data: [
            {
              name: '盖板涵',
              count: 455
            },
            {
              name: '管涵',
              count: 455
            },
            {
              name: '箱涵',
              count: 455
            },
            {
              name: '拱涵',
              count: 455
            },
            {
              name: '倒虹吸',
              count: 455
            }
          ]
        }
      ],
      modularIndex: 0, //浮动在地图上的操作模块的索引
      listData: [
        {
          key: 0,
          name: '桥梁',
          isActive: true,
          isHover: false,
          url: require('../../../../assets/baseStruct/brg.png'),
          active: require('../../../../assets/baseStruct/brg-active.png')
        },
        {
          key: 1,
          name: '隧道',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/tunnel.png'),
          active: require('../../../../assets/baseStruct/tunnel-active.png')
        },

        {
          key: 2,
          name: '涵洞',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/hd.png'),
          active: require('../../../../assets/baseStruct/hd-active.png')
        },
        {
          key: 3,
          name: '收费站',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/gantry.png'),
          active: require('../../../../assets/baseStruct/gantry-active.png')
        },
        {
          key: 4,
          name: '服务区',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/area.png'),
          active: require('../../../../assets/baseStruct/area-active.png')
        },
        {
          key: 5,
          name: '养护车辆',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/yhcl.png'),
          active: require('../../../../assets/baseStruct/yhcl-active.png')
        },
        {
          key: 6,
          name: '养护工区',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/conserve.png'),
          active: require('../../../../assets/baseStruct/conserve-active.png')
        },
        {
          key: 7,
          name: '救援点',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/rescue.png'),
          active: require('../../../../assets/baseStruct/rescue-active.png')
        },
        {
          key: 8,
          name: '应急物资库',
          isActive: false,
          isHover: false,
          url: require('../../../../assets/baseStruct/emergency.png'),
          active: require('../../../../assets/baseStruct/emergency-active.png')
        },
        // {
        //   key: 9,
        //   name: '边坡',
        //   isActive: false,
        //   isHover: false,
        //   url: require('../../../../assets/baseStruct/bp.png'),
        //   active: require('../../../../assets/baseStruct/bp-active.png')
        // }
      ],
      roadLineArr: []
    }
  },
  // watch: {
  //   option10(newValue, oldValue) {
  //     console.log(newValue,oldValue,'监听')
  //     this.option10 = { ...this.option10 }
  //   }
  // },
  created() {
    console.log(option[12], 'option')
    this.getData()
    this.getCompany() //获取公司信息
    this.roadData = this.getroad() //获取路段信息
    this.getAllStructureCount() //获取各个结构数量
    this.getRoadData() //初始化基础数据路段数据
    this.getBridgeCategoryData() //桥梁类别统计数据
    this.getTunnelGradeData() //隧道等级统计数据
    this.getMileageData() //获取里程排行榜
    this.getMaintenanceStation() //养护车辆统计
    this.getCompanyPerson() //各个公司人员数量
  },
  methods: {
    //获取里程排行榜
    getMileageData() {
      this.$http
        .post('${yhxt}/baseDataStatistics/v1/getMileage', this.queryMileage)
        .then(res => {
          let data = []
          res.data.forEach(item => {
            data.push({
              name: item.companyName,
              value: Number(item.mileage)
            })
          })
          this.config9.data = data
          this.config9 = {...this.config9}
        })
    },
    // //养护车辆统计
    // getMaintenanceStation() {
    //   this.$http
    //     .post(
    //       '${yhxt}/baseDataStatistics/v1/countVehicle',
    //       this.queryMileage
    //     )
    //     .then(res => {
    //       let arrName = []
    //       let arrCount = []
    //       console.log(res)
    //       res.data.value.forEach(item => {
    //         arrName.push(item.roadSegmentName)
    //         arrCount.push(Number(item.countVehicle))
    //       })
    //       console.log(arrCount)
    //       // arrCount=[0, 3, 0, 0, 3, 0, 0, 0]
    //       // console.log(arrCount)
    //       console.log(this.option10)
    //       this.option10.xAxis.data = arrName
    //       console.log(this.option10.xAxis)
    //       this.option10.series[0].data = arrCount

    //       if (this.queryMileage.roadSegmentId) {
    //         this.option10.series[0].type = 'bar'
    //       } else {
    //         this.option10.series[0].type = 'line'
    //       }
    //       this.option10 = { ...this.option10 }
    //     })
    // },
    //获取各个公司人员数量
    getCompanyPerson() {
      this.$http
        .post('${yhxt}/baseDataStatistics/v1/getUserCount', this.queryMileage)
        .then(res => {
          // console.log(res ,'fffffffffffffffff')
          // let userConstructionCountArr = [] //施工人员
          let userInspectionCountArr = [] //巡查人员
          let userMaintainCountArr = [] //养护人员
          let userManageCountArr = [] //管理人员
          let companyNameArr = [] //公司名
          res.data.forEach(item => {
            // userConstructionCountArr.push(Number(item.userConstructionCount))
            userInspectionCountArr.push(Number(item.userInspectionCount))
            userMaintainCountArr.push(Number(item.userMaintainCount))
            userManageCountArr.push(Number(item.userManageCount))
            companyNameArr.push(item.roadSegmentName)
          })
          this.option11.xAxis.data = companyNameArr
          this.option11.series[0].data = userManageCountArr
          this.option11.series[1].data = userInspectionCountArr
          this.option11.series[2].data = userMaintainCountArr
          // this.option11.series[3].data = userConstructionCountArr
          this.option11 = {...this.option11}
        })
    },
    loadData(param, cb) {
      param.pageBean = {
        page: 1,
        pageSize: -1,
        showTotal: true
      }
      // if (this.query.roadSegmentId) {

      //   param.pageBean = {
      //     page: 1,
      //     pageSize: -1,
      //     showTotal: true
      //   }
      //   param.querys = [
      //     {
      //       group: 'advance',
      //       operation: 'LIKE',
      //       property: '',
      //       relation: 'AND',
      //       value: ''
      //     }
      //   ]
      //   if (this.BasicType == 1) {
      //     console.log('进这里')
      //     param.querys[0].property = 'id'
      //   }
      //   else {
      //     console.log('进这里2')
      //     param.querys[0].property = 'road_segment_id_'
      //   }
      //   console.log('进这里3')
      //   param.querys[0].value = this.query.roadSegmentId
      // }
      if (this.BasicType == 1) {
        param.querys = [
          {
            group: 'advance',
            operation: 'LIKE',
            property: '',
            relation: 'AND',
            value: ''
          }
        ]
        param.querys[0].property = 'type'
        param.querys[0].value = '4'
      } else if (this.BasicType == 2) {
        param.querys = [
          {
            group: 'advance',
            operation: 'LIKE',
            property: '',
            relation: 'AND',
            value: ''
          }
        ]
        param.querys[0].property = 'type'
        param.querys[0].value = '3'
      }

      this.$http
        .post('${yhxt}' + this.BasicUrl, param)
        .then(response => {
          let rows = response.data
          this.BasicData = rows.rows
          console.log(rows, this.BasicData)
          this.loadingBasic = true
          this.pageResult = {
            page: rows.page,
            pageSize: -1,
            total: rows.total
          }
        })
        .finally(() => {
          if (cb) {
            cb()
          }
        })
    },
    initMap() {
      const map = new AMap.Map('map', {
        resizeEnable: true,
        draggable: true,
        mapStyle: 'amap://styles/260ac3de881fb752fdf854ea2b2540d8',
        // mapStyle: 'amap://styles/darkblue', //地图主题
        center: this.mapCenter, //[106.192515, 29.771075],
        features: ['road', 'point'], //bg:区域图, road:道路, building:建筑, point: 标注
        zoom: 8, //地图显示的缩放级别
        zooms: [7, 18]
      })
      this.map = map
      this.initRoadLine()
      // this.getBridgeMapData() //获取桥梁地图数据
      //监听地图缩放事件
      // this.map.on('zoomend', () => {
      //   this.destroy()
      //   this.mapZoom = this.map.getZoom()
      //   if (Number(this.mapZoom) >= 12) {
      //     this.getBridgeMapData() //获取桥梁地图数据
      //   }
      // })
      this.map.on('complete', () => {
        // 地图图块加载完成后触发
        this.mapLoading = true
      })
    },
    drawAreaLine() {
      //获取边界坐标点
      AMap.plugin('AMap.DistrictSearch', () => {
        var districtSearch = new AMap.DistrictSearch({
          // 关键字对应的行政区级别，共有5种级别
          level: 'province',
          //  是否显示下级行政区级数，1表示返回下一级行政区
          subdistrict: 0,
          // 返回行政区边界坐标点
          extensions: 'all'
        })

        // 搜索所有省/直辖市信息
        districtSearch.search('重庆', (status, result) => {
          // 查询成功时，result即为对应的行政区信息
          this.handlePolygon(result)
        })
      })
    },
    handlePolygon(result) {
      let bounds = result.districtList[0].boundaries
      if (bounds) {
        for (let i = 0, l = bounds.length; i < l; i++) {
          //生成行政区划polygon
          let polygon = new AMap.Polygon({
            map: this.map, // 指定地图对象
            strokeWeight: 1, // 轮廓线宽度
            path: bounds[i], //轮廓线的节点坐标数组
            fillOpacity: 0.15, //透明度
            fillColor: '#0f2a3f', //填充颜色
            strokeColor: '#256edc' //线条颜色
          })
          polygon.on('click', e => {
            // 点击绘制的区域时执行其他交互
          })
        }
        // // 地图自适应
        // this.map.setFitView()
      }
    },
    //初始化路段高亮
    initRoadLine() {
      let params = {
        pageBean: {
          page: -1,
          pageSize: 3,
          showTotal: true
        },
        sorter: []
      }
      this.$http
        .post('${yhxt}/road/roadmanage/v1/getList', params)
        .then(res => {
          let data = res.data.rows
          let arr = []
          data.forEach(item => {
            if (
              item.upStartPegLng &&
              item.upStartPegLat &&
              item.upEndPegLng &&
              item.upEndPegLat &&
              item.dwStartPegLng &&
              item.dwStartPegLat &&
              item.dwEndPegLng &&
              item.dwEndPegLat
            ) {
              if (
                item.upWayLng &&
                item.upWayLat &&
                item.dwWayLng &&
                item.dwWayLat
              ) {
                arr.push({
                  id: item.id,
                  name: item.name,
                  upStartPegLngLat: [item.upStartPegLng, item.upStartPegLat],
                  upEndPegLngLat: [item.upEndPegLng, item.upEndPegLat],
                  dwStartPegLngLat: [item.dwStartPegLng, item.dwStartPegLat],
                  dwEndPegLngLat: [item.dwEndPegLng, item.dwEndPegLat],
                  upWayLngLat: [item.upWayLng, item.upWayLat],
                  dwWayLngLat: [item.dwWayLng, item.dwWayLat]
                })
              } else {
                arr.push({
                  id: item.id,
                  name: item.name,
                  upStartPegLngLat: [item.upStartPegLng, item.upStartPegLat],
                  upEndPegLngLat: [item.upEndPegLng, item.upEndPegLat],
                  dwStartPegLngLat: [item.dwStartPegLng, item.dwStartPegLat],
                  dwEndPegLngLat: [item.dwEndPegLng, item.dwEndPegLat]
                })
              }
            }
          })
          this.getByLngLatLine(arr)
        })
      this.drawAreaLine() //行政区域边界线
    },
    //根据坐标规划线路
    getByLngLatLine(arr) {
      arr.forEach(item => {
        console.log(item, '5555555555')
        if (item.upWayLngLat && item.dwWayLngLat) {
          console.log(item)
          //上行
          AMap.plugin('AMap.Driving', () => {
            let driving = new AMap.Driving()
            // 根据起终点经纬度规划驾车导航路线
            driving.search(
              item.upStartPegLngLat,
              item.upEndPegLngLat,
              {
                waypoints: [item.upWayLngLat]
              },
              (status, result) => {
                this.roadLineArr.push({
                  id: item.id,
                  name: item.name,
                  line: result.routes[0]
                })
                this.drawRoute(result.routes[0])
              }
            )
          })
          //下行
          AMap.plugin('AMap.Driving', () => {
            let driving = new AMap.Driving()
            // 根据起终点经纬度规划驾车导航路线
            driving.search(
              item.dwStartPegLngLat,
              item.dwEndPegLngLat,
              {
                waypoints: [item.dwWayLngLat]
              },
              (status, result) => {
                this.drawRoute(result.routes[0])
              }
            )
          })
        } else {
          //上行
          AMap.plugin('AMap.Driving', () => {
            let driving = new AMap.Driving()
            // 根据起终点经纬度规划驾车导航路线
            driving.search(
              item.upStartPegLngLat,
              item.upEndPegLngLat,
              (status, result) => {
                this.roadLineArr.push({
                  id: item.id,
                  name: item.name,
                  line: result.routes[0]
                })
                this.drawRoute(result.routes[0])
              }
            )
          })
          //下行
          AMap.plugin('AMap.Driving', () => {
            let driving = new AMap.Driving()
            // 根据起终点经纬度规划驾车导航路线
            driving.search(
              item.dwStartPegLngLat,
              item.dwEndPegLngLat,
              (status, result) => {
                this.drawRoute(result.routes[0])
              }
            )
          })
        }
      })
    },
    setFitView(route) {
      let path = this.parseRouteToPath(route)
      AMap.plugin('AMap.Polyline', () => {
        let routeLine = new AMap.Polyline({
          path: path
        })
        // 缩放地图到合适的视野级别
        this.map.setFitView(routeLine)
      })
    },
    //
    drawRoute(route) {
      let path = this.parseRouteToPath(route)
      AMap.plugin('AMap.Polyline', () => {
        let routeLine = new AMap.Polyline({
          path: path,
          strokeWeight: 5,
          strokeStyle: 'solid',
          strokeColor: '#70afff',
          lineJoin: 'round',
          lineCap: 'round'
        })
        // this.map.add(routeLine)
        routeLine.setMap(this.map)
        // 缩放地图到合适的视野级别
        // this.map.setFitView([routeLine])
        // this.map.setZoomAndCenter(10, [106.192515, 29.771075]) //同时设置地图层级与中心点
      })
    },
    //
    parseRouteToPath(route) {
      let path = []

      for (var i = 0, l = route.steps.length; i < l; i++) {
        var step = route.steps[i]

        for (var j = 0, n = step.path.length; j < n; j++) {
          // path.push(step.path[j])
          path.push([step.path[j].lng, step.path[j].lat])
        }
      }

      return path
    },
    markerSign(data, type) {
      this.markerType = type
      data.forEach(item => {
        this.locationMark(item.x, item.y, '')
      })
    },
    changeIcon() {
      let icon
      if (this.markerType == 'culvert') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/涵洞.png')
        })
      } else if (this.markerType == 'bridge') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/桥梁.png')
        })
      } else if (this.markerType == 'sideSlope') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/边坡.png')
        })
      } else if (this.markerType == 'tunnel') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/隧道.png')
        })
      } else if (this.markerType == 'roadSide') {
        this.AraryMapData.forEach(item => {
          if (item.type == '1' || item.type == '2') {
            icon = new AMap.Icon({
              size: new AMap.Size(48, 48),
              image: require('../../../../assets/mapImg/互通.png')
            })
          } else if (item.type == '3') {
            icon = new AMap.Icon({
              size: new AMap.Size(48, 48),
              image: require('../../../../assets/mapImg/收费站.png')
            })
          } else if (item.type == '4') {
            icon = new AMap.Icon({
              size: new AMap.Size(48, 48),
              image: require('../../../../assets/mapImg/服务区.png')
            })
          }
        })
      } else if (this.markerType == 'car') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/车辆_map.png')
        })
      } else if (this.markerType == 'gongqu') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/qu_mini.png')
        })
      } else if (this.markerType == 'jiuyuan') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/jiuyun_mini.png')
        })
      } else if (this.markerType == 'yinji') {
        icon = new AMap.Icon({
          size: new AMap.Size(48, 48),
          image: require('../../../../assets/mapImg/ku_mini.png')
        })
      }
      //点聚合
      this.AraryMapData.forEach(item => {
        this.markers[this.modularIndex].push(
          new AMap.Marker({
            position: [item.lng, item.lat],
            offset: new AMap.Pixel(-15, -15),
            icon: icon,
            size: new AMap.Size(30, 37), //图标大小
            imageSize: new AMap.Size(30, 37),
            extData: item //存储数据
          })
        )
      })
    },
    //点聚合
    pointAggregation() {
      this.changeIcon()
      this.map.plugin(['AMap.MarkerClusterer'], () => {
        this.cluster = new AMap.MarkerClusterer(
          this.map,
          this.markers[this.modularIndex],
          {
            gridSize: 80,
            minClusterSize: 6
          }
        )
      })
      //清除定时器
      // this.map.on('mousemove', () => {
      //   if (this.time1) {
      //     // console.log('dddddddddd')
      //     clearInterval(this.time1)
      //     this.time1 = false
      //   }
      // })
      // //启动
      // this.map.on('mouseout', () => {
      //   if (!this.time1) {
      //     this.time1 = setInterval(this.handleMove, 3000)
      //   }
      // })
      //设置信息窗体
      this.setInfoWindow()
    },
    setInfoWindow() {
      //信息窗体
      let infoWindow = new AMap.InfoWindow({
        offset: new AMap.Pixel(0, -30)
      })
      this.markers.forEach((item, index) => {
        if (index == 0) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:400px;display:flex;justify-content:space-between;flex-wrap:wrap;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥梁编号 :
                              <span style='color:#fff'>
                                ${obj.number ? obj.number : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥梁名称 :
                              <span style='color:#fff'>
                                ${obj.name ? obj.name : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              管养单位 :
                              <span style='color:#fff'>
                                ${obj.officeName ? obj.officeName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥梁类型 :
                              <span style='color:#fff'>
                                ${obj.typeValue ? obj.typeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥梁方向 :
                              <span style='color:#fff'>
                                ${obj.directionValue ? obj.directionValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              建成日期 :
                              <span style='color:#fff'>
                                ${obj.finishDay ? obj.finishDay : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              倾斜斜坡 :
                              <span style='color:#fff'>
                                ${obj.inclinedslope ? obj.inclinedslope : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥面铺装 :
                              <span style='color:#fff'>
                                ${
                                  obj.surfaceinstallValue
                                    ? obj.surfaceinstallValue
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              上部结构类型 :
                              <span style='color:#fff'>
                                ${obj.shapeTypeValue ? obj.shapeTypeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桥梁长度 :
                              <span style='color:#fff'>
                                ${obj.length ? obj.length : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              跨径组合 :
                              <span style='color:#fff'>
                                ${obj.spanCombo ? obj.spanCombo : '-'}
                              </span>
                            </p>
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 1) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:400px;display:flex;justify-content:space-between;flex-wrap:wrap;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道编号 :
                              <span style='color:#fff'>
                                ${obj.number ? obj.number : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道名称 :
                              <span style='color:#fff'>
                                ${obj.name ? obj.name : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所属路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              管养单位 :
                              <span style='color:#fff'>
                                ${obj.officeName ? obj.officeName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道类型 :
                              <span style='color:#fff'>
                                ${obj.typeValue ? obj.typeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道等级 :
                              <span style='color:#fff'>
                                ${obj.gradeValue ? obj.gradeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道方向 :
                              <span style='color:#fff'>
                                ${obj.directionValue ? obj.directionValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              建成年月 :
                              <span style='color:#fff'>
                                ${obj.finishDay ? obj.finishDay : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道长度 :
                              <span style='color:#fff'>
                                ${obj.length ? obj.length : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道宽度 :
                              <span style='color:#fff'>
                                ${obj.width ? obj.width : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              隧道高度 :
                              <span style='color:#fff'>
                                ${obj.hight ? obj.hight : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              洞身材料 :
                              <span style='color:#fff'>
                                ${
                                  obj.bodyMaterialValue
                                    ? obj.bodyMaterialValue
                                    : '-'
                                }
                              </span>
                            </p>
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 2) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:400px;display:flex;justify-content:space-between;flex-wrap:wrap;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              涵洞编号 :
                              <span style='color:#fff'>
                                ${obj.number ? obj.number : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              涵洞类型 :
                              <span style='color:#fff'>
                                ${obj.typeValue ? obj.typeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              管养单位 :
                              <span style='color:#fff'>
                                ${obj.officeName ? obj.officeName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              方向 :
                              <span style='color:#fff'>
                                ${obj.directionValue ? obj.directionValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              完成日期 :
                              <span style='color:#fff'>
                                ${obj.finishDay ? obj.finishDay : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              洞身高度 :
                              <span style='color:#fff'>
                                ${obj.height ? obj.height : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              洞身长度 :
                              <span style='color:#fff'>
                                ${obj.length ? obj.length : '-'} 米
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              孔数 :
                              <span style='color:#fff'>
                                ${obj.holeCount ? obj.holeCount : '-'} 个
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              顶部材料 :
                              <span style='color:#fff'>
                                ${
                                  obj.topMaterialValue
                                    ? obj.topMaterialValue
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              洞身材料 :
                              <span style='color:#fff'>
                                ${
                                  obj.bodyMaterialValue
                                    ? obj.bodyMaterialValue
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              用途 :
                              <span style='color:#fff'>
                                ${obj.usesValue ? obj.usesValue : '-'}
                              </span>
                            </p>
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 3) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:400px;display:flex;justify-content:space-between;flex-wrap:wrap;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              编号 :
                              <span style='color:#fff'>
                                ${obj.number ? obj.number : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              收费站名字 :
                              <span style='color:#fff'>
                                ${obj.name ? obj.name : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              管养单位 :
                              <span style='color:#fff'>
                                ${obj.officeName ? obj.officeName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              方向 :
                              <span style='color:#fff'>
                                ${obj.directionValue ? obj.directionValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              完成日期 :
                              <span style='color:#fff'>
                                ${obj.finishDay ? obj.finishDay : '-'}
                              </span>
                            </p>
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 4) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:400px;display:flex;justify-content:space-between;flex-wrap:wrap;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              名称 :
                              <span style='color:#fff'>
                                ${obj.number == undefined ? '-' : obj.name}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              类型 :
                              <span style='color:#fff'>
                                ${obj.typeValue ? obj.typeValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              方向 :
                              <span style='color:#fff'>
                                ${obj.directionValue ? obj.directionValue : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桩号值 :
                              <span style='color:#fff'>
                                ${obj.pegK ? obj.pegK : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              桩号 :
                              <span style='color:#fff'>
                                ${obj.peg ? obj.peg : '-'}
                              </span>
                            </p>
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 6) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:200px;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              名称 :
                              <span style='color:#fff'>
                                ${obj.name == undefined ? '-' : obj.name}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                         
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 7) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:200px;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              名称 :
                              <span style='color:#fff'>
                              ${obj.name == undefined ? '-' : obj.name}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                          
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else if (index == 8) {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:200px;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              名称 :
                              <span style='color:#fff'>
                              ${obj.name == undefined ? '-' : obj.name}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              所在路段 :
                              <span style='color:#fff'>
                                ${
                                  obj.roadSegmentName
                                    ? obj.roadSegmentName
                                    : '-'
                                }
                              </span>
                            </p>
                         
                        </div>
                      `
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        } else {
          item.forEach(item1 => {
            let obj = item1.getExtData()
            item1.on('mousemove', e => {
              item1.content = `
                    <div style='background: #002352; color: #fff;padding: 5px 10px; border-radius: 10px;width:200px;'>
                        <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              车牌号 :
                              <span style='color:#fff'>
                                ${obj.carNumber ? obj.carNumber : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              品牌 :
                              <span style='color:#fff'>
                                ${obj.carType ? obj.carType : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              司机 :
                              <span style='color:#fff'>
                                ${obj.carDriverName ? obj.carDriverName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              公司 :
                              <span style='color:#fff'>
                                ${obj.companyName ? obj.companyName : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              车辆颜色 :
                              <span style='color:#fff'>
                                ${obj.carColour ? obj.carColour : '-'}
                              </span>
                            </p>
                          <p style='margin:5px 0;font-size:14px;font-weight:bold;color:#179afe;width:200px'>
                              购买时间 :
                              <span style='color:#fff'>
                                ${obj.buyDate ? obj.buyDate : '-'}
                              </span>
                            </p>
                            
                        </div>
                      `
              // <div style='width:100%;height:30px;display:flex; justify-content:center;align-items:center;border-top: 1px solid #fff;'>
              //           <span style='cursor:pointer;font-size:18px'>
              //             <i class="el-icon-caret-right" style='font-size:24px;z-index:9999' id='carPlay'></i>
              //           </span>
              //       </div>
              infoWindow.setContent(item1.content)
              infoWindow.open(this.map, e.target.getPosition())
              this.infoWindow = infoWindow
            })
            item1.on('click', e => {
              this.infoWindow.close()
              this.showVideoModel = true
            })
            item1.on('mouseout', e => {
              this.infoWindow.close()
            })
          })
        }

        // if (this.markerType == 'car') {
        //   let btnPlay = document.getElementById('carPlay')
        //   if (btnPlay) {
        //     btnPlay.onclick = () => {
        //       this.map.clearInfoWindow()
        //       this.getVideoURL()
        //       this.showVideo = true
        //     }
        //   }
        // }
      })
    },
    //基础数据点击事件
    handleBasicDataClick(data) {
      this.loadingBasic = false
      this.index = data.index
      if (data.index == 3) {
        //路段
        // this.BasicUrl = '/baseDataStatistics/v1/getRoad'
        // this.config16.header = ['编号', '名称', '起点', '终点', '长度']
        // this.BasicType = 1 /road/roadmanage/v1/getJson
        this.BasicUrl = '/bizSideSlopeInformation/v1/getJson'
        this.BasicType = 3
        this.$refs.htTable.load()
      } else if (data.index == 1) {
        //沿线设施数据
        // this.BasicUrl = '/baseDataStatistics/v1/getRoadsideFacilities'
        // this.config16.header = ['名称', '类型', '方向', '桩号值', '所属路段']
        // this.BasicType = 2
        this.BasicUrl =
          '/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/getJson'
        this.BasicType = 1
        this.$refs.htTable.load()
      } else if (data.index == 2) {
        //边坡数据
        // this.BasicUrl = '/baseDataStatistics/v1/getSideSlop'
        // this.config16.header = [
        //   '编号',
        //   '所在路段',
        //   '起点桩号',
        //   '止点桩号',
        //   '高度(m)'
        // ]
        // this.BasicType = 3
        this.BasicUrl =
          '/bizRoadsideFacilities/bizRoadsideFacilitiesManager/v1/getJson'
        this.BasicType = 2
        this.$refs.htTable.load()
      } else if (data.index == 4) {
        // this.BasicUrl = '/baseDataStatistics/v1/getBridgeInformation'
        // this.config16.header = [
        //   '编号',
        //   '名称',
        //   '方向',
        //   '桥梁类型',
        //   '桥梁分类',
        //   '长度(km)'
        // ]
        // this.BasicType = 4
        this.BasicUrl = '/bizBridgeInformation/v1/getJson'
        this.BasicType = 4
        this.$refs.htTable.load()
      } else if (data.index == 5) {
        // this.BasicUrl = '/baseDataStatistics/v1/getTunnelInformation'
        // this.config16.header = [
        //   '编号',
        //   '名称',
        //   '隧道长度(m)',
        //   '隧道类型',
        //   '隧道等级'
        // ]
        // this.BasicType = 5
        this.BasicUrl = '/bizTunnelInformation/v1/getJson'
        this.BasicType = 5
        this.$refs.htTable.load()
      } else if (data.index == 6) {
        // this.BasicUrl = '/baseDataStatistics/v1/getCulvertInformation'
        // this.config16.header = [
        //   '编号',
        //   '涵洞高度(m)',
        //   '涵洞长度(m)',
        //   '用途',
        //   '涵洞类型'
        // ]
        // this.BasicType = 6
        this.BasicUrl =
          '/bizCulvertInformation/bizCulvertInformationmanager/v1/getJson'
        this.BasicType = 6
        this.$refs.htTable.load()
      }
      // this.getRoadBasic(this.BasicUrl) //基础概况基础设施
    },
    //鼠标移入
    enter(data) {
      let index = data.key
      this.listData[index].isHover = true
    },
    //鼠标移除
    leave(data) {
      let index = data.key
      this.listData[index].isHover = false
    }
  }
}
