export const accountMixin = {
  data() {
    return {
      username: 'admin', //用户名
      groupCodeArr: [] //角色编码
    }
  },
  created() {
    let orgAccount = JSON.parse(window.sessionStorage.getItem('currentUser'))
      .account
    this.getOrgInfo(orgAccount)
    this.username = JSON.parse(
      window.sessionStorage.getItem('currentUser')
    ).username
  },
  methods: {
    //获取级角色信息
    getOrgInfo(orgAccount) {
      this.$http
        .get('${yhxt}/api/role/v1/role/getRolesByUser?account=' + orgAccount)
        .then(res => {
          if (res.data.length != 0) {
            res.data.forEach(item => {
              this.groupCodeArr.push(item.groupCode)
            })
            console.log(this.groupCodeArr, 'd')
          }
        })
    },
    //退出系统
    handleLogout() {
      this.$store.dispatch('menu/clearMenus')
      this.$store.dispatch('user/clearUser')
      this.$store.dispatch('menu/setCopyMenus', []) //菜单
      let loginRouthPath =
        localStorage.getItem(
          this.$store.state.login.currentUser.account + 'loginRoutePath'
        ) || '/login'
      this.$store.dispatch('login/logoutAndCleanUp').then(() => {
        switch (window.ssoConfig.mode) {
          case 'cas':
          case 'oauth':
            window.sessionStorage.removeItem('currentUser')
            window.location.href =
              window.ssoConfig.logout +
              '?service=' +
              window.location.href.split('?')[0]
            break
          default:
            this.$router.push({
              path: loginRouthPath
            })
            break
        }
      })
    }
  }
}
