package com.artfess.workflow.bpmModel.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 
 * 通用流程授权对象表
 * @company 广州宏天软件股份有限公司
 * @author 超级管理员
 * @since 2020-11-04
 */
@ApiModel("通用流程授权对象表")
@TableName("bpm_often_flow_user")
public class BpmOftenFlowUser extends BaseModel<BpmOftenFlowUser> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "常用流程表主键ID")
    @TableField("OFTEN_FLOW_ID_")
    private String oftenFlowId;

    @ApiModelProperty(value = "授权对象ID")
    @TableField("OWNER_ID_")
    private String ownerId;

    @ApiModelProperty(value = "授权对象名称")
    @TableField("OWNER_NAME_")
    private String ownerName;

    @ApiModelProperty(value = "授权对象类型(角色,用户,岗位等)")
    @TableField("RIGHT_TYPE_")
    private String rightType;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getOftenFlowId() {
        return oftenFlowId;
    }

    public void setOftenFlowId(String oftenFlowId) {
        this.oftenFlowId = oftenFlowId;
    }
    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
    public String getRightType() {
        return rightType;
    }

    public void setRightType(String rightType) {
        this.rightType = rightType;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BpmOftenFlowUser{" +
            "id=" + id +
            ", oftenFlowId=" + oftenFlowId +
            ", ownerId=" + ownerId +
            ", ownerName=" + ownerName +
            ", rightType=" + rightType +
            ", tenantId=" + tenantId +
        "}";
    }
}
